/*
 * last modified---
 * 	10-31-25 v0.2.6 Beta (initial Launch version)
 * 	10-09-25 v0.2.5 Beta (deployed to Mainnet, but not yet publicly available)
 * 	05-16-25 v0.2.4 Beta (final versions of contracts)
 * 	03-28-25 v0.2.3 Beta (add receipt downloads and eNFT wallet save/restore)
 * 	01-29-25 v0.2.2 Beta (add DAOPool management)
 * 	11-20-24 v0.2.1 Beta (add MVOStaking management)
 * 	07-26-24 v0.2.0 Beta (add Crowdsale and stubs for staking pages)
 * 	04-30-24 v0.1.2 Beta
 * 	04-17-24 v0.1.1 Beta, add support forum link
 * 	03-26-24 v0.1.0 Beta
 * 	09-13-23 new
 *
 * purpose---
 * 	footer for dApp pages
 */

import React from 'react';
import Container from 'react-bootstrap/Container';

function EnshFooter() {
	return (
		<footer>
			<Container align="center" className="d-flex-inline">
				Version 0.2.6 Beta &middot; 05 November, 2025 &middot;
				Enshroud Developers &middot;&nbsp;
				<small>
					<a href="https://enshroud.info" target="_blank" rel="noreferrer noopener">
						Website
					</a>
					&nbsp;&middot;
					<a href="https://support.enshroud.info:7443/inverse/#converse/login" target="_blank" rel="noreferrer noopener">
						Support forum
					</a>
					&nbsp;&middot;
					<a href="mailto:support@enshroud.info">
						Email
					</a>
					<br/>
					<i>Social media links TBD</i>
					<br/>
					<i>
						Market token prices courtesy
						of <a href="https://chain.link/" target="_blank"
							rel="noreferrer noopener">
							chain.link
						</a>
					</i>
				</small>
			</Container>
		</footer>
	);
}

export default EnshFooter;
