/*
 * last modified---
 * 	10-08-25 add contract addresses and genesis blocks for Eth Mainnet;
 * 			 remove Ganache and place Sepolia 2nd; refine token/pricefeed list
 * 	09-12-25 add Falcon USD to Mainnet suggested coin list
 * 	04-03-25 add suggested coins to template list for Eth Mainnet
 * 	03-18-25 add chain.link priceFeed entries for aggregatorV3InterfaceABI
 * 	02-26-24 add Sepolia section
 * 	01-05-24 update protocolGenesis to block 355; Ganache now at 192.168.1.7
 * 	12-07-23 new
 *
 * purpose---
 * 	provide definitions for all supported blockchain
 */

// ******** begin definitions for all supported chains
const chainConfigs = [
/*
	{	// local Ganache node
		chainId: 1337,
		chain: "Ganache",
		// this URL is a suggestion, the actual URL will come from givenProvider
		jsonrpcURL: 'ws://192.168.1.7:8545',
		scanURL: '',	// (not natively supported)
		protocolGenesis: 854,
		tokenGenesis: 197,
		assetList:
			[	 { symbol: "ETH",
				   contractAddress:"0x0000000000000000000000000000000000000000",
				   balanceOf: 0n,
				   method: 'native',
				   wrapsTo: "0x9745800493fC45ad2Dd122Dc267FB5eAd3e3D1f2",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "WETH",
				   contractAddress:"0x9745800493fC45ad2Dd122Dc267FB5eAd3e3D1f2",
				   balanceOf: 0n,
				   method: 'tokens',
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "ENSHROUD",
				   contractAddress:"0xE1c08596DEb9465184820f2815182157db42757B",
				   balanceOf: 0n,
				   method: 'permit',
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "DAI",
					// NB: mainnet address, doesn't really exist on Ganache
				   contractAddress:"0x6B175474E89094C44Da98b954EedeAC495271d0F",
				   balanceOf: 0n,
				   method: 'permit',
				   depositFee: 0.3,
				   withdrawFee: 0.3 }
			],
		defaultDepFee: 0.3,
		defaultWithFee: 0.3,
	},
 */

	{	// Eth Mainnet
		chainId: 1,
		chain: "Ethereum",
		// this URL is a suggestion, the actual URL will come from givenProvider
		jsonrpcURL: 'https://mainnet.infura.io',
		scanURL: 'https://etherscan.io',
		protocolGenesis: 23530292,
		tokenGenesis: 23530288,
		assetList:
			[	 { symbol: "ETH",
				   contractAddress:"0x0000000000000000000000000000000000000000",
				   balanceOf: 0n,
				   method: 'native',
				   wrapsTo: "0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
				   priceFeed: "0x5f4eC3Df9cbd43714FE2740f5E3616155c5b8419",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "ENSHROUD",
				   contractAddress:"0xBE819Dc859c2eBe1f15FCad08727355CE1CE8f68",
				   balanceOf: 0n,
				   method: 'permit',
				   depositFee: 0.2,
				   withdrawFee: 0.2 },
				 { symbol: "WETH",
				   contractAddress:"0xC02aaA39b223FE8D0A0e5C4F27eAD9083C756Cc2",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x5f4eC3Df9cbd43714FE2740f5E3616155c5b8419",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "WBTC",
				   contractAddress:"0x2260fac5e5542a773aa44fbcfedf7c193bc2c599",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xF4030086522a5bEEa4988F8cA5B36dbC97BeE88c",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "DAI",
				   contractAddress:"0x6B175474E89094C44Da98b954EedeAC495271d0F",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xAed0c38402a5d19df6E4c03F4E2DceD6e29c1ee9",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDS",
				   contractAddress:"0xdC035D45d973E3EC169d2276DDab16f1e407384F",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xfF30586cD0F29eD462364C7e81375FC0C71219b1",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDT",
				   contractAddress:"0xdac17f958d2ee523a2206206994597c13d831ec7",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x3E7d1eAB13ad0104d2750B8863b489D65364e32D",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDC",
				   contractAddress:"0xa0b86991c6218b36c1d19d4a2e9eb0ce3606eb48",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x8fFfFfd4AfB6115b954Bd326cbe7B4BA576818f6",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDE",
				   contractAddress:"0x4c9edd5852cd905f086c759e8383e09bff1e68b3",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xa569d910839Ae8865Da8F8e70FfFb0cBA869F961",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDF",
				   contractAddress:"0xFa2B947eEc368f42195f24F36d2aF29f7c24CeC2",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xb177857a1799aA5F7fEb5799Fdf12CbE8fdF78B1",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "FDUSD",
				   contractAddress:"0xc5f0f7b66764F6ec8C8Dff7BA683102295E16409",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xfAA9147190c2C2cc5B8387B4f49016bDB3380572",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "TUSD",
				   contractAddress:"0x0000000000085d4780B73119b644AE5ecd22b376",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xec746eCF986E2927Abd291a2A1716c940100f8Ba",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USD1",
				   contractAddress:"0x8d0d000ee44948fc98c9b98a4fa4921476f08b0d",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xF0d9bb015Cd7BfAb877B7156146dc09Bf461370d",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDG",
				   contractAddress:"0xe343167631d89B6Ffc58B88d6b7fB0228795491D",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0x14f0737d6b705259e521EA6E9E3506AC78dBd311",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "PYUSD",
				   contractAddress:"0x6c3ea9036406852006290770bedfcaba0e23a0e8",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0x8f1dF6D7F2db73eECE86a18b4381F4707b918FB1",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "AAVE",
				   contractAddress:"0x7Fc66500c84A76Ad7e9c93437bFc5Ac33E2DDaE9",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0x547a514d5e3769680Ce22B2361c10Ea13619e8a9",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "BAL",
				   contractAddress:"0xba100000625a3754423978a60c9317c58a424e3D",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xdF2917806E30300537aEB49A7663062F4d1F2b5F",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "CRV",
				   contractAddress:"0xD533a949740bb3306d119CC777fa900bA034cd52",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xCd627aA160A6fA45Eb793D19Ef54f5062F20f33f",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "EURC",
				   contractAddress:"0x1abaea1f7c830bd89acc67ec4af516284b1bc33c",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xCd627aA160A6fA45Eb793D19Ef54f5062F20f33f",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "GRT",
				   contractAddress:"0xc944e90c64b2c07662a292be6244bdf05cda44a7",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0x86cF33a451dE9dc61a2862FD94FF4ad4Bd65A5d2",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "GUSD",
				   contractAddress:"0x056Fd409E1d7A124BD7017459dFEa2F387b6d5Cd",
				   balanceOf: 0n,
				   method: 'tokens',
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "LINK",
				   contractAddress:"0x514910771af9ca656af840dff83e8264ecf986ca",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x2c1d072e956AFFC0D435Cb7AC38EF18d24d9127c",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "MKR",
				   contractAddress:"0x9f8f72aa9304c8b593d555f12ef6589cc3a579a2",
				   balanceOf: 0n,
				   method: 'tokens',
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "PAXG",
				   contractAddress:"0x45804880de22913dafe09f4980848ece6ecbaf78",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x9944D86CEB9160aF5C5feB251FD671923323f8C3",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "SAND",
				   contractAddress:"0x3845badAde8e6dFF049820680d1F14bD3903a5d0",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x35E3f7E558C04cE7eEE1629258EcbbA03B36Ec56",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "SKY",
				   contractAddress:"0x56072C95FAA701256059aa122697B133aDEd9279",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xee10fE5E7aa92dd7b136597449c3d5813cFC5F18",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "SNX",
				   contractAddress:"0xc011a73ee8576fb46f5e1c5751ca3b9fe0af2a6f",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xDC3EA94CD0AC27d9A86C180091e7f78C683d3699",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "SUSHI",
				   contractAddress:"0x6b3595068778dd592e39a122f4f5a5cf09c90fe2",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xCc70F09A6CC17553b2E31954cD36E4A2d89501f7",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "UNI",
				   contractAddress:"0x1f9840a85d5af5bf1d1762f925bdaddc4201f984",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0x553303d460EE0afB37EdFf9bE42922D8FF63220e",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "YFI",
				   contractAddress:"0x0bc529c00c6401aef6d220be8c6ea1667f6ad93e",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xA027702dbb89fbd58938e4324ac03B58d812b0E1",
				   depositFee: 0.3,
				   withdrawFee: 0.3 }
			],
		defaultDepFee: 0.3,
		defaultWithFee: 0.3,
	},

	{	// Sepolia testnet
		chainId: 11155111,
		chain: "Sepolia",
		// this URL is a suggestion, the actual URL will come from givenProvider
		jsonrpcURL: 'https://eth.api.onfinality.io/public',
		scanURL: 'https://sepolia.etherscan.io',
		protocolGenesis: 8329553,
		tokenGenesis: 7591976,
		assetList:
			[	 { symbol: "SepoliaETH",
				   contractAddress:"0x0000000000000000000000000000000000000000",
				   balanceOf: 0n,
				   method: 'native',
				   wrapsTo: "0xC2F550Beb305AD6e2C910b68aB0593a7967B1878",
				   priceFeed: "0x694AA1769357215DE4FAC081bf1f309aDC325306",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "WETH",
				   contractAddress:"0xC2F550Beb305AD6e2C910b68aB0593a7967B1878",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0x694AA1769357215DE4FAC081bf1f309aDC325306",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "ENSHROUD",
				   contractAddress:"0x7bA32A25E01F24b6c4D94783a3C154840268344d",
				   balanceOf: 0n,
				   method: 'permit',
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "DAI",
				   contractAddress:"0x552ceaDf3B47609897279F42D3B3309B604896f3",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0x14866185B1962B63C3Ea9E03Bc1da838bab34C19",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "SNX",
				   contractAddress:"0x079E7E1C0cBFee4B2D2798A9d426009D08b1F9cb",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xc0F82A46033b8BdBA4Bb0B0e28Bc2006F64355bC",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "LINK",
				   contractAddress:"0x779877A7B0D9E8603169DdbD7836e478b4624789",
				   balanceOf: 0n,
				   method: 'tokens',
				   priceFeed: "0xc59E3633BAAC79493d908e63626716e204A45EdF",
				   depositFee: 0.3,
				   withdrawFee: 0.3 },
				 { symbol: "USDC",
				   contractAddress:"0x7Fc21ceb0C5003576ab5E101eB240c2b822c95d2",
				   balanceOf: 0n,
				   method: 'permit',
				   priceFeed: "0xA2F78ab2355fe2f984D808B5CeE7FD0A93D5270E",
				   depositFee: 0.3,
				   withdrawFee: 0.3 }
			],
		defaultDepFee: 0.3,
		defaultWithFee: 0.3,
	}
];
// ******** end definitions for all supported chains

export default chainConfigs;
