package cc.enshroud.jetty.wrappers;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint120;
import org.web3j.abi.datatypes.generated.Uint128;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint96;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tuples.generated.Tuple2;
import org.web3j.tuples.generated.Tuple4;
import org.web3j.tuples.generated.Tuple8;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 1.4.2.
 */
@SuppressWarnings("rawtypes")
public class MVOStaking extends Contract {
    public static final String BINARY = "0x61010060405260015f55604051613a86380380613a86833981016040819052610027916101f9565b6001805480820182555f8290527fb10e2d527612073b26eecdfd717e6a320cf44b4afac2b0732d9fcbe2b7fa0cf60180546001600160a01b0319166001600160a01b0387811691909117909155600291909155838116608081905290831660e05260c05260048190554360a0526100a9670de0b6b3a7640000624c4b40610241565b60015f52600e6020527fa7c5ba7114a813b50159add3a36832908dc83db71d0b9a24c2ad0f83be958207556100e9670de0b6b3a7640000623d0900610241565b60025f52600e6020527f9adb202b1492743bc00c81d33cdc6423fa8c79109027eb6a845391e8fc1f048155610129670de0b6b3a7640000622dc6c0610241565b60035f52600e6020527fe0283e559c29e31ee7f56467acc9dd307779c843a883aeeb3bf5c6128c90814455610169670de0b6b3a7640000621e8480610241565b60045f52600e6020527fa1d6913cd9e08c872be3e7525cca82e4fc0fc298a783f19022be725b19be685a556101a9670de0b6b3a7640000620f4240610241565b60055f52600e6020527fb9bec7e2561f624fe753ff070f1599b306cbf59fafd4e8d5a8184a1ea1841bce555061026a92505050565b80516001600160a01b03811681146101f4575f5ffd5b919050565b5f5f5f5f6080858703121561020c575f5ffd5b610215856101de565b9350610223602086016101de565b9250610231604086016101de565b6060959095015193969295505050565b808202811582820484141761026457634e487b7160e01b5f52601160045260245ffd5b92915050565b60805160a05160c05160e0516137b16102d55f395f81816105450152611e5f01525f81816106d4015281816123c6015261248b01525f818161035e01526121b001525f818161046c01528181610740015281816109f601528181611897015261203501526137b15ff3fe608060405234801561000f575f5ffd5b5060043610610208575f3560e01c80638b0e9f3f1161011f578063bbeb3955116100a9578063c38b84a111610079578063c38b84a114610570578063c4df873f14610583578063cb85180c14610596578063f3fe12c9146105a9578063fc68a230146105bc575f5ffd5b8063bbeb3955146104cc578063beaf95f3146104df578063bf5669bd14610540578063c0fd4e0214610567575f5ffd5b8063aa7b43e1116100ef578063aa7b43e11461043e578063ab50ba4114610447578063acf2040c14610467578063b4601259146104a6578063bb21aa52146104b9575f5ffd5b80638b0e9f3f146103fc5780638cdb442f146104055780638db44153146104185780639494c8ae1461042b575f5ffd5b806345ed3db1116101a0578063567142be11610170578063567142be14610393578063727a573c1461039c5780637c1c485d146103af5780637ef76c3c146103c25780638accb951146103d5575f5ffd5b806345ed3db114610333578063475ebbf2146103465780634cdc9c631461035957806352cc854a14610380575f5ffd5b806330b39a62116101db57806330b39a62146102cd57806332954365146102e0578063375b3c0a1461030b5780634399197714610314575f5ffd5b80631369a9271461020c57806318aed3c71461028257806318edaaf21461029757806325ca4cff146102ae575b5f5ffd5b61024e61021a366004612b07565b60106020525f90815260409020805460018201546002909201549091906001600160801b0380821691600160801b90041684565b6040805194855260208501939093526001600160801b03918216928401929092521660608201526080015b60405180910390f35b610295610290366004612b66565b6105cf565b005b6102a060035481565b604051908152602001610279565b6102a06102bc366004612b07565b600b6020525f908152604090205481565b6102956102db366004612be1565b6107f9565b6102a06102ee366004612c3c565b8051602081830181018051600c8252928201919093012091525481565b6102a060045481565b6102a0610322366004612cec565b600e6020525f908152604090205481565b610295610341366004612be1565b610aa9565b610295610354366004612d03565b610c1f565b6102a07f000000000000000000000000000000000000000000000000000000000000000081565b61029561038e366004612d91565b610ddb565b6102a060075481565b6102956103aa366004612b07565b610fdc565b6102956103bd366004612cec565b611146565b6102956103d0366004612b07565b611230565b6103e86103e3366004612c3c565b61135e565b604051610279989796959493929190612e4b565b6102a060065481565b610295610413366004612cec565b6114da565b610295610426366004612ebc565b611608565b610295610439366004612be1565b6117c4565b6102a060025481565b61045a610455366004612cec565b61194a565b6040516102799190612f2a565b61048e7f000000000000000000000000000000000000000000000000000000000000000081565b6040516001600160a01b039091168152602001610279565b61048e6104b4366004612cec565b6119f0565b6102956104c7366004612f3c565b611a18565b6102956104da366004612f7a565b611a96565b6105196104ed366004612cec565b600f6020525f90815260409020546001600160a01b03811690600160a01b90046001600160601b031682565b604080516001600160a01b0390931683526001600160601b03909116602083015201610279565b61048e7f000000000000000000000000000000000000000000000000000000000000000081565b6102a060055481565b61029561057e366004612fc1565b611b4c565b610295610591366004612ff3565b611d44565b6102956105a436600461307a565b611e54565b6102956105b7366004612f3c565b6120f0565b6102956105ca366004612f7a565b612529565b5f546002036105f15760405163558a1e0360e11b815260040160405180910390fd5b60025f55604051600d9061060890899089906130f3565b90815260405190819003602001902060010154336001600160a01b03909116146106455760405163b147cb7560e01b815260040160405180910390fd5b8460065f8282546106569190613116565b9250508190555084600d88886040516106709291906130f3565b90815260200160405180910390206004015f82825461068f9190613116565b909155505060405163d505accf60e01b8152336004820152306024820152604481018690526064810185905260ff8416608482015260a4810183905260c481018290527f00000000000000000000000000000000000000000000000000000000000000006001600160a01b03169063d505accf9060e4015f604051808303815f87803b15801561071d575f5ffd5b505af115801561072f573d5f5f3e3d5ffd5b5061076a9250506001600160a01b037f000000000000000000000000000000000000000000000000000000000000000016905033308861269b565b6040805186815243602082015233917f95c2d1682da1c94cf72722155675f023c7e909538f90354357762bd45925ea70910160405180910390a25f51602061375c5f395f51905f528787600d8a8a6040516107c69291906130f3565b908152604051908190036020018120600401546107e4939291613157565b60405180910390a1505060015f555050505050565b5f5460020361081b5760405163558a1e0360e11b815260040160405180910390fd5b60025f55604051600d9061083290859085906130f3565b90815260405190819003602001902060010154336001600160a01b039091161461086f5760405163b147cb7560e01b815260040160405180910390fd5b80600d84846040516108829291906130f3565b90815260200160405180910390206004015410156108b357604051638f201a7360e01b815260040160405180910390fd5b335f9081526010602052604090206001015480156109b357335f908152601060205260408120546108e590839061317a565b6108ee336126e3565b6108f8919061317a565b90505f82600d878760405161090e9291906130f3565b90815260200160405180910390206004015461092a919061317a565b90506109368183613116565b8411156109565760405163a2d2891f60e01b815260040160405180910390fd5b83821061098957335f908152601060205260408120600101805486929061097e90849061317a565b909155506109b09050565b335f90815260106020526040812060010180548492906109aa90849061317a565b90915550505b50505b81600d85856040516109c69291906130f3565b9081526040519081900360200190206004018054919091039055600680548390039055610a1d6001600160a01b037f0000000000000000000000000000000000000000000000000000000000000000163384612767565b6040805183815243602082015233917f54e8265d924142b11826bd303e79a36db5df2ce53901fd41c19e40008818a35a910160405180910390a25f51602061375c5f395f51905f528484600d8787604051610a799291906130f3565b90815260405190819003602001812060040154610a97939291613157565b60405180910390a1505060015f555050565b600180600254610ab9919061317a565b81548110610ac957610ac961318d565b5f91825260209091200154604051633e4a89d160e01b81523360048201526001600160a01b0390911690633e4a89d190602401602060405180830381865afa158015610b17573d5f5f3e3d5ffd5b505050506040513d601f19601f82011682018060405250810190610b3b91906131ae565b610b5857604051637bfa4b9f60e01b815260040160405180910390fd5b5f600d8484604051610b6b9291906130f3565b9081526040805160209281900383019020600101546001600160a01b03165f818152600b909352912054909150821115610bb8576040516397b7798b60e01b815260040160405180910390fd5b6001600160a01b0381165f818152600b60205260409081902080548590039055600780548590039055517fc3b6eea41a8033c9dffd641ba61665d9b9d5d33a3e2db4bb87952eff9d02d88d90610c119085815260200190565b60405180910390a250505050565b831580610c4157505f848152600f60205260409020546001600160a01b031615155b15610c5f5760405163ee15045d60e01b815260040160405180910390fd5b6706f05b59d3b200008310610c8757604051632ebbf31b60e21b815260040160405180910390fd5b600d8282604051610c999291906130f3565b90815260405190819003602001902060010154336001600160a01b0390911614610cd65760405163b147cb7560e01b815260040160405180910390fd5b610ce08282611a18565b335f908152600b602052604090205415610d0d57604051633aaf97d160e11b815260040160405180910390fd5b6040805180820182523381526001600160601b0380861660208084019182525f898152600f90915284902092519051909116600160a01b026001600160a01b0391909116179055518490600d90610d6790859085906130f3565b90815260405190819003602001812060050180546001600160781b03939093166001600160781b0319909316929092179091557f588475b865c1e30d6d4caa2e0da2b4009157a04d3f2ab7d0d3b3aa08f985ef8390610dcd9086908690869086906131c9565b60405180910390a150505050565b5f54600203610dfd5760405163558a1e0360e11b815260040160405180910390fd5b60025f556008546001600160a01b03163314610e2c576040516308d722fb60e41b815260040160405180910390fd5b46851480610e38575084155b15610e5657604051633d23e4d160e11b815260040160405180910390fd5b821580610e635750828114155b15610e84576040516001621398b960e31b0319815260040160405180910390fd5b5f5b83811015610fd0575f600d868684818110610ea357610ea361318d565b9050602002810190610eb591906131f2565b604051610ec39291906130f3565b90815260405190819003602001902060018101549091506001600160a01b031680610f015760405163c668fa8d60e01b815260040160405180910390fd5b848484818110610f1357610f1361318d565b6001600160a01b0384165f908152600b6020908152604090912080549290910293909301350190915550848484818110610f4f57610f4f61318d565b600780546020909202939093013501909155506001600160a01b0381167f2292e1cf0767804f0c9d4e1f6a5c721c2e11d13a76402bc549936f0f5a27af6a868686818110610f9f57610f9f61318d565b905060200201358a604051610fbe929190918252602082015260400190565b60405180910390a25050600101610e86565b505060015f5550505050565b600180600254610fec919061317a565b81548110610ffc57610ffc61318d565b5f91825260209091200154604051633e4a89d160e01b81523360048201526001600160a01b0390911690633e4a89d190602401602060405180830381865afa15801561104a573d5f5f3e3d5ffd5b505050506040513d601f19601f8201168201806040525081019061106e91906131ae565b61108b57604051637bfa4b9f60e01b815260040160405180910390fd5b3360c01b61109b828260016127a6565b15611142576001805480820182557fb10e2d527612073b26eecdfd717e6a320cf44b4afac2b0732d9fcbe2b7fa0cf60180546001600160a01b0319166001600160a01b038516908117909155600280549092019091555f818152600a602090815260409182902080546001600160881b031916905590519182527f5d7ee3a2caa09465a672230cd161ff80d4c30aa4f31bd8f3e03249d859d24a2c91015b60405180910390a15b5050565b600180600254611156919061317a565b815481106111665761116661318d565b5f91825260209091200154604051633e4a89d160e01b81523360048201526001600160a01b0390911690633e4a89d190602401602060405180830381865afa1580156111b4573d5f5f3e3d5ffd5b505050506040513d601f19601f820116820180604052508101906111d891906131ae565b6111f557604051637bfa4b9f60e01b815260040160405180910390fd5b60038190556040518181527fe64e12d565716cb1d472831954a8aa6b8f660bd3d1ac40f26d0484b74061ee9b9060200160405180910390a150565b600180600254611240919061317a565b815481106112505761125061318d565b5f91825260209091200154604051633e4a89d160e01b81523360048201526001600160a01b0390911690633e4a89d190602401602060405180830381865afa15801561129e573d5f5f3e3d5ffd5b505050506040513d601f19601f820116820180604052508101906112c291906131ae565b6112df57604051637bfa4b9f60e01b815260040160405180910390fd5b3360c01b6112ef828260026127a6565b1561114257600880546001600160a01b0319166001600160a01b0384169081179091555f818152600a602090815260409182902080546001600160881b031916905590519182527f727ff814ae487612c4f2a334a45b1ffd2142f287950070c6d0eb667beaecf9799101611139565b8051602081830181018051600d8252928201919093012091528054819061138490613234565b80601f01602080910402602001604051908101604052809291908181526020018280546113b090613234565b80156113fb5780601f106113d2576101008083540402835291602001916113fb565b820191905f5260205f20905b8154815290600101906020018083116113de57829003601f168201915b5050506001840154600285015460038601805495966001600160a01b039384169692909316945091925061142e90613234565b80601f016020809104026020016040519081016040528092919081815260200182805461145a90613234565b80156114a55780601f1061147c576101008083540402835291602001916114a5565b820191905f5260205f20905b81548152906001019060200180831161148857829003601f168201915b5050505060048301546005909301549192916001600160781b038082169250600160781b82041690600160f01b900460ff1688565b6001806002546114ea919061317a565b815481106114fa576114fa61318d565b5f91825260209091200154604051633e4a89d160e01b81523360048201526001600160a01b0390911690633e4a89d190602401602060405180830381865afa158015611548573d5f5f3e3d5ffd5b505050506040513d601f19601f8201168201806040525081019061156c91906131ae565b61158957604051637bfa4b9f60e01b815260040160405180910390fd5b3360c01b8161159981835f6127a6565b156116035760048390556001600160a01b0381165f908152600a60205260409081902080546001600160881b0319169055517ff4045d7dd317de89564c3f12c35961242ed2a4dce3ae4e7a75847ffa04bb0834906115fa9085815260200190565b60405180910390a15b505050565b600180600254611618919061317a565b815481106116285761162861318d565b5f91825260209091200154604051633e4a89d160e01b81523360048201526001600160a01b0390911690633e4a89d190602401602060405180830381865afa158015611676573d5f5f3e3d5ffd5b505050506040513d601f19601f8201168201806040525081019061169a91906131ae565b6116b757604051637bfa4b9f60e01b815260040160405180910390fd5b5f6001600160a01b0316600d84846040516116d39291906130f3565b908152604051908190036020019020600101546001600160a01b03160361176057600980546001810182555f919091527f6e1540171b6c0c960b71a7020d9f60077f6af931a8bbf590da0223dacf75c7af016117308385836132b7565b50600554600c84846040516117469291906130f3565b908152604051908190036020019020556005805460010190555b80600d84846040516117739291906130f3565b90815260405190819003602001902061178c82826133c8565b9050507fcf33f5de1ef67e6e5ec8006d8cff0400a249c994a029dea6b1926a58c8024546838383466040516115fa94939291906135dd565b5f546002036117e65760405163558a1e0360e11b815260040160405180910390fd5b60025f55604051600d906117fd90859085906130f3565b90815260405190819003602001902060010154336001600160a01b039091161461183a5760405163b147cb7560e01b815260040160405180910390fd5b8060065f82825461184b9190613116565b9250508190555080600d84846040516118659291906130f3565b90815260200160405180910390206004015f8282546118849190613116565b909155506118bf90506001600160a01b037f00000000000000000000000000000000000000000000000000000000000000001633308461269b565b6040805182815243602082015233917f95c2d1682da1c94cf72722155675f023c7e909538f90354357762bd45925ea70910160405180910390a25f51602061375c5f395f51905f528383600d868660405161191b9291906130f3565b90815260405190819003602001812060040154611939939291613157565b60405180910390a1505060015f5550565b60098181548110611959575f80fd5b905f5260205f20015f91509050805461197190613234565b80601f016020809104026020016040519081016040528092919081815260200182805461199d90613234565b80156119e85780601f106119bf576101008083540402835291602001916119e8565b820191905f5260205f20905b8154815290600101906020018083116119cb57829003601f168201915b505050505081565b600181815481106119ff575f80fd5b5f918252602090912001546001600160a01b0316905081565b600d8282604051611a2a9291906130f3565b9081526040519081900360200190206005015460ff600160f01b909104161580611a785750600454600d8383604051611a649291906130f3565b908152602001604051809103902060040154105b156111425760405163c668fa8d60e01b815260040160405180910390fd5b600d8282604051611aa89291906130f3565b90815260405190819003602001902060010154336001600160a01b03909116141580611aea57505f838152600f60205260409020546001600160a01b03163314155b15611b085760405163b147cb7560e01b815260040160405180910390fd5b5f838152600f602052604080822091909155517fed2863a3907531988ef6702ca5ff5df0d5e70ab1434c2751d510fdd8059a1a9a906115fa908590859085906136da565b600180545b8015611ba7576001611b63818361317a565b81548110611b7357611b7361318d565b5f918252602090912001546001600160a01b03163303611b95575f9150611ba7565b80611b9f816136fc565b915050611b51565b508015611bc757604051630dc68e0d60e41b815260040160405180910390fd5b5f600d84845f818110611bdc57611bdc61318d565b9050602002810190611bee91906131f2565b604051611bfc9291906130f3565b90815260408051602092819003830190206001808201546001600160a01b03165f908152600b90945291909220805460039081019091556007805490910190559091505b83811015611cfc575f600d868684818110611c5d57611c5d61318d565b9050602002810190611c6f91906131f2565b604051611c7d9291906130f3565b90815260408051602092819003830181206001908101546001600160a01b03165f818152600b865284902080548301905560078054830190558183524694830194909452949094019391925082917f2292e1cf0767804f0c9d4e1f6a5c721c2e11d13a76402bc549936f0f5a27af6a910160405180910390a250611c40565b50600181015460408051600381524660208201526001600160a01b03909216917f2292e1cf0767804f0c9d4e1f6a5c721c2e11d13a76402bc549936f0f5a27af6a9101610c11565b5f5f5f611d8586868080601f0160208091040260200160405190810160405280939291908181526020018383808284375f92019190915250612aa092505050565b9250925092505f6001858585856040515f8152602001604052604051611dc7949392919093845260ff9290921660208401526040830152606082015260800190565b6020604051602081039080840390855afa158015611de7573d5f5f3e3d5ffd5b505050602060405103519050806001600160a01b0316600d8a8a604051611e0f9291906130f3565b908152604051908190036020019020600201546001600160a01b031614611e4957604051638baa579f60e01b815260040160405180910390fd5b505050505050505050565b336001600160a01b037f00000000000000000000000000000000000000000000000000000000000000001614611e9d576040516320b78e0160e21b815260040160405180910390fd5b600d8686604051611eaf9291906130f3565b908152604051908190036020019020600101546001600160a01b03848116911614611eed5760405163b147cb7560e01b815260040160405180910390fd5b8360065f828254611efe9190613116565b9250508190555083600d8787604051611f189291906130f3565b90815260200160405180910390206004015f828254611f379190613116565b90915550506001600160a01b0383165f9081526010602052604090206001015415611fbd576001600160a01b0383165f9081526010602052604081208054869290611f83908490613116565b90915550506001600160a01b0383165f9081526010602052604081206001018054869290611fb2908490613116565b909155506120289050565b6040805160808101825285815260208082018781526001600160801b03808716848601908152868216606086019081526001600160a01b038a165f9081526010909552959093209351845590516001840155905192518116600160801b029216919091176002909101555b61205d6001600160a01b037f00000000000000000000000000000000000000000000000000000000000000001633308761269b565b604080518581524360208201526001600160a01b038516917f95c2d1682da1c94cf72722155675f023c7e909538f90354357762bd45925ea70910160405180910390a25f51602061375c5f395f51905f528686600d89896040516120c29291906130f3565b908152604051908190036020018120600401546120e0939291613157565b60405180910390a1505050505050565b5f546002036121125760405163558a1e0360e11b815260040160405180910390fd5b60025f55604051600d9061212990849084906130f3565b90815260405190819003602001902060010154336001600160a01b03909116146121665760405163b147cb7560e01b815260040160405180910390fd5b5f600d83836040516121799291906130f3565b908152604080516020928190038301902060050154335f908152600b909352908220546001600160781b03909116925090806121d57f00000000000000000000000000000000000000000000000000000000000000004361317a565b90506121e56227d2566005613711565b811115612205576040516303a6269f60e51b815260040160405180910390fd5b6227d256811161221857600191506122e6565b6227d2568111801561223757506122336227d2566002613711565b8111155b1561224557600291506122e6565b6122536227d2566002613711565b8111801561226e575061226a6227d2566003613711565b8111155b1561227c57600391506122e6565b61228a6227d2566003613711565b811180156122a557506122a16227d2566004613711565b8111155b156122b357600491506122e6565b6122c16227d2566004613711565b811180156122dc57506122d86227d2566005613711565b8111155b156122e657600591505b5f6122f4836227d256613711565b5f848152600e602052604090205461230d908490613711565b6123179190613728565b90505f60075482866123299190613711565b6123339190613728565b90508460075f828254612346919061317a565b9091555050335f908152600b60209081526040808320839055868352600e9091528120805483929061237990849061317a565b90915550505f868152600f6020526040812054670de0b6b3a7640000906123b090600160a01b90046001600160601b031684613711565b6123ba9190613728565b90506001600160a01b037f0000000000000000000000000000000000000000000000000000000000000000166340c10f19336123f6848661317a565b6040516001600160e01b031960e085901b1681526001600160a01b03909216600483015260248201526044015f604051808303815f87803b158015612439575f5ffd5b505af115801561244b573d5f5f3e3d5ffd5b50505050805f146124e5575f878152600f6020526040908190205490516340c10f1960e01b81526001600160a01b039182166004820152602481018390527f0000000000000000000000000000000000000000000000000000000000000000909116906340c10f19906044015f604051808303815f87803b1580156124ce575f5ffd5b505af11580156124e0573d5f5f3e3d5ffd5b505050505b60405186815233907fc3b6eea41a8033c9dffd641ba61665d9b9d5d33a3e2db4bb87952eff9d02d88d9060200160405180910390a2505060015f5550505050505050565b600d828260405161253b9291906130f3565b90815260405190819003602001902060010154336001600160a01b03909116146125785760405163b147cb7560e01b815260040160405180910390fd5b335f908152600b6020526040902054156125a557604051633aaf97d160e11b815260040160405180910390fd5b82158015906125c857505f838152600f60205260409020546001600160a01b0316155b156125e6576040516302721e1f60e61b815260040160405180910390fd5b6125f08282611a18565b5f600d83836040516126039291906130f3565b908152604051908190036020018120600501546001600160781b031691508490600d9061263390869086906130f3565b90815260200160405180910390206005015f6101000a8154816001600160781b0302191690836001600160781b03160217905550837f9969f40ab26a744c07f08a9a272e0e8e5a8485a11a4b0e524453a08ed4f90a7f828585604051610c11939291906136da565b6040516323b872dd5f5283602052826040528160605260205f6064601c5f895af13d1560015f511417166126d657637939f4245f526004601cfd5b5f60605260405250505050565b6001600160a01b0381165f90815260106020526040812060028101546001600160801b0380821691600160801b900416438210612722575f935061275f565b804310612732578254935061275f565b61273c828261317a565b612746834361317a565b84546127529190613711565b61275c9190613728565b93505b505050919050565b60405163a9059cbb5f52826020528160405260205f6044601c5f885af13d1560015f5114171661279e576390b8ec185f526004601cfd5b604052505050565b6001600160a01b0383165f908152600a6020526040812054819060c01b6001600160c01b031916612838576001600160a01b0385165f908152600a60205260409020805460c086901c67ffffffffffffffff1982168117835585929170ff0000000000000000ffffffffffffffff191617600160801b83600281111561282e5761282e613747565b0217905550612a94565b6001600160a01b0385165f908152600a602052604090205460c01b6001600160c01b03199081169082161480159061289d57506001600160a01b0385165f908152600a60205260409020546001600160c01b0319828116600160401b90920460c01b16145b80156128d157506001600160a01b0385165f908152600a602052604090205460c01b6001600160c01b031990811690851614155b801561291f57506001600160a01b0385165f908152600a6020526040902054600160801b900460ff16600281111561290b5761290b613747565b83600281111561291d5761291d613747565b145b15612963576001600160a01b0385165f908152600a6020526040902080546fffffffffffffffff00000000000000001916600160401b60c087901c02179055612a94565b6001600160a01b0385165f908152600a602052604090205460c01b6001600160c01b0319908116908216148015906129c957506001600160a01b0385165f908152600a60205260409020546001600160c01b0319828116600160401b90920460c01b1614155b80156129fd57506001600160a01b0385165f908152600a602052604090205460c01b6001600160c01b031990811690851614155b8015612a3757506001600160a01b0385165f908152600a60205260409020546001600160c01b0319858116600160401b90920460c01b1614155b8015612a8557506001600160a01b0385165f908152600a6020526040902054600160801b900460ff166002811115612a7157612a71613747565b836002811115612a8357612a83613747565b145b15612a94576001915050612a99565b5f9150505b9392505050565b5f5f5f8351604114612ac55760405163cbaa79dd60e01b815260040160405180910390fd5b505050602081015160408201516060909201515f1a92909190565b6001600160a01b0381168114612af4575f5ffd5b50565b8035612b0281612ae0565b919050565b5f60208284031215612b17575f5ffd5b8135612a9981612ae0565b5f5f83601f840112612b32575f5ffd5b5081356001600160401b03811115612b48575f5ffd5b602083019150836020828501011115612b5f575f5ffd5b9250929050565b5f5f5f5f5f5f5f60c0888a031215612b7c575f5ffd5b87356001600160401b03811115612b91575f5ffd5b612b9d8a828b01612b22565b9098509650506020880135945060408801359350606088013560ff81168114612bc4575f5ffd5b969995985093969295946080840135945060a09093013592915050565b5f5f5f60408486031215612bf3575f5ffd5b83356001600160401b03811115612c08575f5ffd5b612c1486828701612b22565b909790965060209590950135949350505050565b634e487b7160e01b5f52604160045260245ffd5b5f60208284031215612c4c575f5ffd5b81356001600160401b03811115612c61575f5ffd5b8201601f81018413612c71575f5ffd5b80356001600160401b03811115612c8a57612c8a612c28565b604051601f8201601f19908116603f011681016001600160401b0381118282101715612cb857612cb8612c28565b604052818152828201602001861015612ccf575f5ffd5b816020840160208301375f91810160200191909152949350505050565b5f60208284031215612cfc575f5ffd5b5035919050565b5f5f5f5f60608587031215612d16575f5ffd5b843593506020850135925060408501356001600160401b03811115612d39575f5ffd5b612d4587828801612b22565b95989497509550505050565b5f5f83601f840112612d61575f5ffd5b5081356001600160401b03811115612d77575f5ffd5b6020830191508360208260051b8501011115612b5f575f5ffd5b5f5f5f5f5f60608688031215612da5575f5ffd5b8535945060208601356001600160401b03811115612dc1575f5ffd5b612dcd88828901612d51565b90955093505060408601356001600160401b03811115612deb575f5ffd5b612df788828901612d51565b969995985093965092949392505050565b5f81518084525f5b81811015612e2c57602081850181015186830182015201612e10565b505f602082860101526020601f19601f83011685010191505092915050565b61010081525f612e5f61010083018b612e08565b6001600160a01b038a81166020850152891660408401528281036060840152612e888189612e08565b608084019790975250506001600160781b0393841660a08201529190921660c082015290151560e090910152949350505050565b5f5f5f60408486031215612ece575f5ffd5b83356001600160401b03811115612ee3575f5ffd5b612eef86828701612b22565b90945092505060208401356001600160401b03811115612f0d575f5ffd5b84016101008187031215612f1f575f5ffd5b809150509250925092565b602081525f612a996020830184612e08565b5f5f60208385031215612f4d575f5ffd5b82356001600160401b03811115612f62575f5ffd5b612f6e85828601612b22565b90969095509350505050565b5f5f5f60408486031215612f8c575f5ffd5b8335925060208401356001600160401b03811115612fa8575f5ffd5b612fb486828701612b22565b9497909650939450505050565b5f5f60208385031215612fd2575f5ffd5b82356001600160401b03811115612fe7575f5ffd5b612f6e85828601612d51565b5f5f5f5f5f60608688031215613007575f5ffd5b85356001600160401b0381111561301c575f5ffd5b61302888828901612b22565b90965094505060208601356001600160401b03811115613046575f5ffd5b61305288828901612b22565b96999598509660400135949350505050565b80356001600160801b0381168114612b02575f5ffd5b5f5f5f5f5f5f60a0878903121561308f575f5ffd5b86356001600160401b038111156130a4575f5ffd5b6130b089828a01612b22565b9097509550506020870135935060408701356130cb81612ae0565b92506130d960608801613064565b91506130e760808801613064565b90509295509295509295565b818382375f9101908152919050565b634e487b7160e01b5f52601160045260245ffd5b8082018082111561312957613129613102565b92915050565b81835281816020850137505f828201602090810191909152601f909101601f19169091010190565b604081525f61316a60408301858761312f565b9050826020830152949350505050565b8181038181111561312957613129613102565b634e487b7160e01b5f52603260045260245ffd5b8015158114612af4575f5ffd5b5f602082840312156131be575f5ffd5b8151612a99816131a1565b848152836020820152606060408201525f6131e860608301848661312f565b9695505050505050565b5f5f8335601e19843603018112613207575f5ffd5b8301803591506001600160401b03821115613220575f5ffd5b602001915036819003821315612b5f575f5ffd5b600181811c9082168061324857607f821691505b60208210810361326657634e487b7160e01b5f52602260045260245ffd5b50919050565b601f82111561160357805f5260205f20601f840160051c810160208510156132915750805b601f840160051c820191505b818110156132b0575f815560010161329d565b5050505050565b6001600160401b038311156132ce576132ce612c28565b6132e2836132dc8354613234565b8361326c565b5f601f841160018114613313575f85156132fc5750838201355b5f19600387901b1c1916600186901b1783556132b0565b5f83815260208120601f198716915b828110156133425786850135825560209485019460019092019101613322565b508682101561335e575f1960f88860031b161c19848701351681555b505060018560011b0183555050505050565b5f813561312981612ae0565b80546001600160a01b0319166001600160a01b0392909216919091179055565b6001600160781b0381168114612af4575f5ffd5b5f81356131298161339c565b5f8135613129816131a1565b6133d282836131f2565b6001600160401b038111156133e9576133e9612c28565b6133fd816133f78554613234565b8561326c565b5f601f82116001811461342e575f83156134175750838201355b5f19600385901b1c1916600184901b178555613485565b5f85815260208120601f198516915b8281101561345d578685013582556020948501946001909201910161343d565b5084821015613479575f1960f88660031b161c19848701351681555b505060018360011b0185555b505050506134a161349860208401613370565b6001830161337c565b6134b96134b060408401613370565b6002830161337c565b6134c660608301836131f2565b6134d48183600386016132b7565b505060808201356004820155600581016135106134f360a085016133b0565b82546001600160781b0319166001600160781b0391909116178255565b61355961351f60c085016133b0565b8280546effffffffffffffffffffffffffffff60781b191660789290921b6effffffffffffffffffffffffffffff60781b16919091179055565b61160361356860e085016133bc565b82805460ff60f01b191691151560f01b60ff60f01b16919091179055565b5f5f8335601e1984360301811261359b575f5ffd5b83016020810192503590506001600160401b038111156135b9575f5ffd5b803603821315612b5f575f5ffd5b8035612b028161339c565b8035612b02816131a1565b606081525f6135f060608301868861312f565b82810360208401526136028586613586565b61010083526136166101008401828461312f565b915050602086013561362781612ae0565b6001600160a01b0316602083015261364160408701612af7565b6001600160a01b0316604083015261365c6060870187613586565b838303606085015261366f83828461312f565b60808981013590860152925061368a91505060a087016135c7565b6001600160781b031660a08301526136a460c087016135c7565b6001600160781b031660c08301526136be60e087016135d2565b80151560e0840152506040939093019390935250949350505050565b838152604060208201525f6136f360408301848661312f565b95945050505050565b5f8161370a5761370a613102565b505f190190565b808202811582820484141761312957613129613102565b5f8261374257634e487b7160e01b5f52601260045260245ffd5b500490565b634e487b7160e01b5f52602160045260245ffdfea505781a5116eef5a80d5b66d75962b0569fae3a78ad4bbb9f70a67da73b61c9a2646970667358221220fe16b2b99c80a43ab02b22286c6ce05d456c8bf1b87f6e133406a9bdf75540ea64736f6c634300081c0033";

    public static final String FUNC_CODEHASH = "codeHash";

    public static final String FUNC_ENSHROUDPROTOCOLS = "enshroudProtocols";

    public static final String FUNC_ENSHROUDTOKEN = "enshroudToken";

    public static final String FUNC_GENESISBLOCK = "genesisBlock";

    public static final String FUNC_IDTOMVO = "idToMVO";

    public static final String FUNC_IDTOMVOPOOL = "idToMVOPool";

    public static final String FUNC_MINSTAKE = "minStake";

    public static final String FUNC_MVOIDS = "mvoIds";

    public static final String FUNC_MVOIDSINDEX = "mvoIdsIndex";

    public static final String FUNC_MVOINDEX = "mvoIndex";

    public static final String FUNC_POINTSBALANCE = "pointsBalance";

    public static final String FUNC_PROTOINDEX = "protoIndex";

    public static final String FUNC_TIMELOCKMANAGER = "timelockManager";

    public static final String FUNC_TIMELOCKS = "timelocks";

    public static final String FUNC_TOTALPOINTS = "totalPoints";

    public static final String FUNC_TOTALSTAKE = "totalStake";

    public static final String FUNC_YEARTOTOKENSREMAINING = "yearToTokensRemaining";

    public static final String FUNC_AWARDPOINTS = "awardPoints";

    public static final String FUNC_IMPORTPOINTS = "importPoints";

    public static final String FUNC_REDUCEPOINTS = "reducePoints";

    public static final String FUNC_CLAIM = "claim";

    public static final String FUNC_STAKE = "stake";

    public static final String FUNC_STAKEWITHPERMIT = "stakeWithPermit";

    public static final String FUNC_STAKETIMELOCK = "stakeTimelock";

    public static final String FUNC_WITHDRAW = "withdraw";

    public static final String FUNC_CREATEMVOPOOL = "createMVOPool";

    public static final String FUNC_DELETEMVOPOOL = "deleteMVOPool";

    public static final String FUNC_UPDATEMVOPOOLMEMBERSHIP = "updateMVOPoolMembership";

    public static final String FUNC_UPDATECODEHASH = "updateCodeHash";

    public static final String FUNC_UPDATEMVOSTATUS = "updateMvoStatus";

    public static final String FUNC_UPDATEMINSTAKE = "updateMinStake";

    public static final String FUNC_UPDATEPROTOCOL = "updateProtocol";

    public static final String FUNC_UPDATEPOINTSBOT = "updatePointsBot";

    public static final String FUNC_CHECKMVOSIG = "checkMVOSig";

    public static final String FUNC_CHECKMVO = "checkMVO";

    public static final Event CODEHASHCHANGED_EVENT = new Event("CodeHashChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Bytes32>() {}));
    ;

    public static final Event MVOPOOLCREATED_EVENT = new Event("MVOPoolCreated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Utf8String>() {}));
    ;

    public static final Event MVOPOOLDELETED_EVENT = new Event("MVOPoolDeleted", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Utf8String>() {}));
    ;

    public static final Event MVOSTAKEUPDATED_EVENT = new Event("MVOStakeUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event MVOSTAKING_PROTOCOLUPDATED_EVENT = new Event("MVOStaking_ProtocolUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event MVOSTAKING_STAKED_EVENT = new Event("MVOStaking_Staked", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event MVOSTAKING_UNSTAKED_EVENT = new Event("MVOStaking_Unstaked", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event MVOSTATUSCHANGED_EVENT = new Event("MVOStatusChanged", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<MVO>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event MINIMUMSTAKEUPDATED_EVENT = new Event("MinimumStakeUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event POINTSAWARDED_EVENT = new Event("PointsAwarded", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event POINTSBOTUPDATED_EVENT = new Event("PointsBotUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
    ;

    public static final Event POINTSREDUCED_EVENT = new Event("PointsReduced", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event POOLMEMBERSHIPUPDATED_EVENT = new Event("PoolMembershipUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Utf8String>() {}));
    ;

    protected static final HashMap<String, String> _addresses;

    static {
        _addresses = new HashMap<String, String>();
        _addresses.put("1337", "0x17Bbbb7A533E78a92096597451dd54887CcB2C58");
        _addresses.put("1", "0xF8017ae65F2cE39B07244e54eCa9Ec640f558C8A");
        _addresses.put("11155111", "0xbe88Fe067D7D363C6f9435278ba2fa0d6fBF481A");
    }

    @Deprecated
    protected MVOStaking(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected MVOStaking(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected MVOStaking(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected MVOStaking(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<CodeHashChangedEventResponse> getCodeHashChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(CODEHASHCHANGED_EVENT, transactionReceipt);
        ArrayList<CodeHashChangedEventResponse> responses = new ArrayList<CodeHashChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            CodeHashChangedEventResponse typedResponse = new CodeHashChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newCodeHash = (byte[]) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<CodeHashChangedEventResponse> codeHashChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, CodeHashChangedEventResponse>() {
            @Override
            public CodeHashChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(CODEHASHCHANGED_EVENT, log);
                CodeHashChangedEventResponse typedResponse = new CodeHashChangedEventResponse();
                typedResponse.log = log;
                typedResponse.newCodeHash = (byte[]) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<CodeHashChangedEventResponse> codeHashChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(CODEHASHCHANGED_EVENT));
        return codeHashChangedEventFlowable(filter);
    }

    public static List<MVOPoolCreatedEventResponse> getMVOPoolCreatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOPOOLCREATED_EVENT, transactionReceipt);
        ArrayList<MVOPoolCreatedEventResponse> responses = new ArrayList<MVOPoolCreatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOPoolCreatedEventResponse typedResponse = new MVOPoolCreatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.poolId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.dues = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.creatorMvoID = (String) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOPoolCreatedEventResponse> mVOPoolCreatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOPoolCreatedEventResponse>() {
            @Override
            public MVOPoolCreatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOPOOLCREATED_EVENT, log);
                MVOPoolCreatedEventResponse typedResponse = new MVOPoolCreatedEventResponse();
                typedResponse.log = log;
                typedResponse.poolId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.dues = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.creatorMvoID = (String) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOPoolCreatedEventResponse> mVOPoolCreatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOPOOLCREATED_EVENT));
        return mVOPoolCreatedEventFlowable(filter);
    }

    public static List<MVOPoolDeletedEventResponse> getMVOPoolDeletedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOPOOLDELETED_EVENT, transactionReceipt);
        ArrayList<MVOPoolDeletedEventResponse> responses = new ArrayList<MVOPoolDeletedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOPoolDeletedEventResponse typedResponse = new MVOPoolDeletedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.poolId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.creatorMvoID = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOPoolDeletedEventResponse> mVOPoolDeletedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOPoolDeletedEventResponse>() {
            @Override
            public MVOPoolDeletedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOPOOLDELETED_EVENT, log);
                MVOPoolDeletedEventResponse typedResponse = new MVOPoolDeletedEventResponse();
                typedResponse.log = log;
                typedResponse.poolId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.creatorMvoID = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOPoolDeletedEventResponse> mVOPoolDeletedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOPOOLDELETED_EVENT));
        return mVOPoolDeletedEventFlowable(filter);
    }

    public static List<MVOStakeUpdatedEventResponse> getMVOStakeUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOSTAKEUPDATED_EVENT, transactionReceipt);
        ArrayList<MVOStakeUpdatedEventResponse> responses = new ArrayList<MVOStakeUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOStakeUpdatedEventResponse typedResponse = new MVOStakeUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.mvoID = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.stakingQuantum = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOStakeUpdatedEventResponse> mVOStakeUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOStakeUpdatedEventResponse>() {
            @Override
            public MVOStakeUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOSTAKEUPDATED_EVENT, log);
                MVOStakeUpdatedEventResponse typedResponse = new MVOStakeUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.mvoID = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.stakingQuantum = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOStakeUpdatedEventResponse> mVOStakeUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOSTAKEUPDATED_EVENT));
        return mVOStakeUpdatedEventFlowable(filter);
    }

    public static List<MVOStaking_ProtocolUpdatedEventResponse> getMVOStaking_ProtocolUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOSTAKING_PROTOCOLUPDATED_EVENT, transactionReceipt);
        ArrayList<MVOStaking_ProtocolUpdatedEventResponse> responses = new ArrayList<MVOStaking_ProtocolUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOStaking_ProtocolUpdatedEventResponse typedResponse = new MVOStaking_ProtocolUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newProtocol = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOStaking_ProtocolUpdatedEventResponse> mVOStaking_ProtocolUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOStaking_ProtocolUpdatedEventResponse>() {
            @Override
            public MVOStaking_ProtocolUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOSTAKING_PROTOCOLUPDATED_EVENT, log);
                MVOStaking_ProtocolUpdatedEventResponse typedResponse = new MVOStaking_ProtocolUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.newProtocol = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOStaking_ProtocolUpdatedEventResponse> mVOStaking_ProtocolUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOSTAKING_PROTOCOLUPDATED_EVENT));
        return mVOStaking_ProtocolUpdatedEventFlowable(filter);
    }

    public static List<MVOStaking_StakedEventResponse> getMVOStaking_StakedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOSTAKING_STAKED_EVENT, transactionReceipt);
        ArrayList<MVOStaking_StakedEventResponse> responses = new ArrayList<MVOStaking_StakedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOStaking_StakedEventResponse typedResponse = new MVOStaking_StakedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.blockNumber = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOStaking_StakedEventResponse> mVOStaking_StakedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOStaking_StakedEventResponse>() {
            @Override
            public MVOStaking_StakedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOSTAKING_STAKED_EVENT, log);
                MVOStaking_StakedEventResponse typedResponse = new MVOStaking_StakedEventResponse();
                typedResponse.log = log;
                typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.blockNumber = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOStaking_StakedEventResponse> mVOStaking_StakedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOSTAKING_STAKED_EVENT));
        return mVOStaking_StakedEventFlowable(filter);
    }

    public static List<MVOStaking_UnstakedEventResponse> getMVOStaking_UnstakedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOSTAKING_UNSTAKED_EVENT, transactionReceipt);
        ArrayList<MVOStaking_UnstakedEventResponse> responses = new ArrayList<MVOStaking_UnstakedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOStaking_UnstakedEventResponse typedResponse = new MVOStaking_UnstakedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.blockNumber = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOStaking_UnstakedEventResponse> mVOStaking_UnstakedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOStaking_UnstakedEventResponse>() {
            @Override
            public MVOStaking_UnstakedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOSTAKING_UNSTAKED_EVENT, log);
                MVOStaking_UnstakedEventResponse typedResponse = new MVOStaking_UnstakedEventResponse();
                typedResponse.log = log;
                typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.blockNumber = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOStaking_UnstakedEventResponse> mVOStaking_UnstakedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOSTAKING_UNSTAKED_EVENT));
        return mVOStaking_UnstakedEventFlowable(filter);
    }

    public static List<MVOStatusChangedEventResponse> getMVOStatusChangedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MVOSTATUSCHANGED_EVENT, transactionReceipt);
        ArrayList<MVOStatusChangedEventResponse> responses = new ArrayList<MVOStatusChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MVOStatusChangedEventResponse typedResponse = new MVOStatusChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.mvoID = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.updatedMVO = (MVO) eventValues.getNonIndexedValues().get(1);
            typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MVOStatusChangedEventResponse> mVOStatusChangedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MVOStatusChangedEventResponse>() {
            @Override
            public MVOStatusChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MVOSTATUSCHANGED_EVENT, log);
                MVOStatusChangedEventResponse typedResponse = new MVOStatusChangedEventResponse();
                typedResponse.log = log;
                typedResponse.mvoID = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.updatedMVO = (MVO) eventValues.getNonIndexedValues().get(1);
                typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MVOStatusChangedEventResponse> mVOStatusChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MVOSTATUSCHANGED_EVENT));
        return mVOStatusChangedEventFlowable(filter);
    }

    public static List<MinimumStakeUpdatedEventResponse> getMinimumStakeUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(MINIMUMSTAKEUPDATED_EVENT, transactionReceipt);
        ArrayList<MinimumStakeUpdatedEventResponse> responses = new ArrayList<MinimumStakeUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            MinimumStakeUpdatedEventResponse typedResponse = new MinimumStakeUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newMinStake = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<MinimumStakeUpdatedEventResponse> minimumStakeUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, MinimumStakeUpdatedEventResponse>() {
            @Override
            public MinimumStakeUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(MINIMUMSTAKEUPDATED_EVENT, log);
                MinimumStakeUpdatedEventResponse typedResponse = new MinimumStakeUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.newMinStake = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<MinimumStakeUpdatedEventResponse> minimumStakeUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(MINIMUMSTAKEUPDATED_EVENT));
        return minimumStakeUpdatedEventFlowable(filter);
    }

    public static List<PointsAwardedEventResponse> getPointsAwardedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(POINTSAWARDED_EVENT, transactionReceipt);
        ArrayList<PointsAwardedEventResponse> responses = new ArrayList<PointsAwardedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            PointsAwardedEventResponse typedResponse = new PointsAwardedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.mvoAddress = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.points = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<PointsAwardedEventResponse> pointsAwardedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, PointsAwardedEventResponse>() {
            @Override
            public PointsAwardedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(POINTSAWARDED_EVENT, log);
                PointsAwardedEventResponse typedResponse = new PointsAwardedEventResponse();
                typedResponse.log = log;
                typedResponse.mvoAddress = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.points = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<PointsAwardedEventResponse> pointsAwardedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(POINTSAWARDED_EVENT));
        return pointsAwardedEventFlowable(filter);
    }

    public static List<PointsBotUpdatedEventResponse> getPointsBotUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(POINTSBOTUPDATED_EVENT, transactionReceipt);
        ArrayList<PointsBotUpdatedEventResponse> responses = new ArrayList<PointsBotUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            PointsBotUpdatedEventResponse typedResponse = new PointsBotUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.botAddress = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<PointsBotUpdatedEventResponse> pointsBotUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, PointsBotUpdatedEventResponse>() {
            @Override
            public PointsBotUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(POINTSBOTUPDATED_EVENT, log);
                PointsBotUpdatedEventResponse typedResponse = new PointsBotUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.botAddress = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<PointsBotUpdatedEventResponse> pointsBotUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(POINTSBOTUPDATED_EVENT));
        return pointsBotUpdatedEventFlowable(filter);
    }

    public static List<PointsReducedEventResponse> getPointsReducedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(POINTSREDUCED_EVENT, transactionReceipt);
        ArrayList<PointsReducedEventResponse> responses = new ArrayList<PointsReducedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            PointsReducedEventResponse typedResponse = new PointsReducedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.mvoAddress = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.points = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<PointsReducedEventResponse> pointsReducedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, PointsReducedEventResponse>() {
            @Override
            public PointsReducedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(POINTSREDUCED_EVENT, log);
                PointsReducedEventResponse typedResponse = new PointsReducedEventResponse();
                typedResponse.log = log;
                typedResponse.mvoAddress = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.points = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<PointsReducedEventResponse> pointsReducedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(POINTSREDUCED_EVENT));
        return pointsReducedEventFlowable(filter);
    }

    public static List<PoolMembershipUpdatedEventResponse> getPoolMembershipUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(POOLMEMBERSHIPUPDATED_EVENT, transactionReceipt);
        ArrayList<PoolMembershipUpdatedEventResponse> responses = new ArrayList<PoolMembershipUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            PoolMembershipUpdatedEventResponse typedResponse = new PoolMembershipUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newPoolId = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.oldPoolId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.memberMvoID = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<PoolMembershipUpdatedEventResponse> poolMembershipUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, PoolMembershipUpdatedEventResponse>() {
            @Override
            public PoolMembershipUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(POOLMEMBERSHIPUPDATED_EVENT, log);
                PoolMembershipUpdatedEventResponse typedResponse = new PoolMembershipUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.newPoolId = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.oldPoolId = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.memberMvoID = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<PoolMembershipUpdatedEventResponse> poolMembershipUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(POOLMEMBERSHIPUPDATED_EVENT));
        return poolMembershipUpdatedEventFlowable(filter);
    }

    public RemoteFunctionCall<byte[]> codeHash() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CODEHASH, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bytes32>() {}));
        return executeRemoteCallSingleValueReturn(function, byte[].class);
    }

    public RemoteFunctionCall<String> enshroudProtocols(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ENSHROUDPROTOCOLS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> enshroudToken() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ENSHROUDTOKEN, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> genesisBlock() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GENESISBLOCK, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Tuple8<String, String, String, String, BigInteger, BigInteger, BigInteger, Boolean>> idToMVO(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_IDTOMVO, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<Address>() {}, new TypeReference<Address>() {}, new TypeReference<Utf8String>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint120>() {}, new TypeReference<Uint120>() {}, new TypeReference<Bool>() {}));
        return new RemoteFunctionCall<Tuple8<String, String, String, String, BigInteger, BigInteger, BigInteger, Boolean>>(function,
                new Callable<Tuple8<String, String, String, String, BigInteger, BigInteger, BigInteger, Boolean>>() {
                    @Override
                    public Tuple8<String, String, String, String, BigInteger, BigInteger, BigInteger, Boolean> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple8<String, String, String, String, BigInteger, BigInteger, BigInteger, Boolean>(
                                (String) results.get(0).getValue(), 
                                (String) results.get(1).getValue(), 
                                (String) results.get(2).getValue(), 
                                (String) results.get(3).getValue(), 
                                (BigInteger) results.get(4).getValue(), 
                                (BigInteger) results.get(5).getValue(), 
                                (BigInteger) results.get(6).getValue(), 
                                (Boolean) results.get(7).getValue());
                    }
                });
    }

    public RemoteFunctionCall<Tuple2<String, BigInteger>> idToMVOPool(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_IDTOMVOPOOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Uint96>() {}));
        return new RemoteFunctionCall<Tuple2<String, BigInteger>>(function,
                new Callable<Tuple2<String, BigInteger>>() {
                    @Override
                    public Tuple2<String, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple2<String, BigInteger>(
                                (String) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue());
                    }
                });
    }

    public RemoteFunctionCall<BigInteger> minStake() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MINSTAKE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> mvoIds(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MVOIDS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> mvoIdsIndex(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MVOIDSINDEX, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> mvoIndex() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_MVOINDEX, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> pointsBalance(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_POINTSBALANCE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> protoIndex() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PROTOINDEX, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> timelockManager() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TIMELOCKMANAGER, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<Tuple4<BigInteger, BigInteger, BigInteger, BigInteger>> timelocks(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TIMELOCKS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint128>() {}, new TypeReference<Uint128>() {}));
        return new RemoteFunctionCall<Tuple4<BigInteger, BigInteger, BigInteger, BigInteger>>(function,
                new Callable<Tuple4<BigInteger, BigInteger, BigInteger, BigInteger>>() {
                    @Override
                    public Tuple4<BigInteger, BigInteger, BigInteger, BigInteger> call() throws Exception {
                        List<Type> results = executeCallMultipleValueReturn(function);
                        return new Tuple4<BigInteger, BigInteger, BigInteger, BigInteger>(
                                (BigInteger) results.get(0).getValue(), 
                                (BigInteger) results.get(1).getValue(), 
                                (BigInteger) results.get(2).getValue(), 
                                (BigInteger) results.get(3).getValue());
                    }
                });
    }

    public RemoteFunctionCall<BigInteger> totalPoints() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALPOINTS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> totalStake() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSTAKE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> yearToTokensRemaining(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_YEARTOTOKENSREMAINING, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> awardPoints(List<String> _mvoIDs) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_AWARDPOINTS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_mvoIDs, org.web3j.abi.datatypes.Utf8String.class))), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> importPoints(BigInteger _chainId, List<String> _mvoIDs, List<BigInteger> _points) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_IMPORTPOINTS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_chainId), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_mvoIDs, org.web3j.abi.datatypes.Utf8String.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_points, org.web3j.abi.datatypes.generated.Uint256.class))), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> reducePoints(String _mvoID, BigInteger _points) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REDUCEPOINTS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID), 
                new org.web3j.abi.datatypes.generated.Uint256(_points)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> claim(String _mvoID) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_CLAIM, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stake(String _mvoID, BigInteger _amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STAKE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stakeWithPermit(String _mvoID, BigInteger _amount, BigInteger _deadline, BigInteger v, byte[] r, byte[] s) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STAKEWITHPERMIT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount), 
                new org.web3j.abi.datatypes.generated.Uint256(_deadline), 
                new org.web3j.abi.datatypes.generated.Uint8(v), 
                new org.web3j.abi.datatypes.generated.Bytes32(r), 
                new org.web3j.abi.datatypes.generated.Bytes32(s)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> stakeTimelock(String _mvoID, BigInteger _amount, String _staker, BigInteger _releaseStart, BigInteger _releaseEnd) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_STAKETIMELOCK, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount), 
                new org.web3j.abi.datatypes.Address(_staker), 
                new org.web3j.abi.datatypes.generated.Uint128(_releaseStart), 
                new org.web3j.abi.datatypes.generated.Uint128(_releaseEnd)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> withdraw(String _mvoID, BigInteger _amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_WITHDRAW, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> createMVOPool(BigInteger _miningPoolId, BigInteger _dues, String _mvoID) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_CREATEMVOPOOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_miningPoolId), 
                new org.web3j.abi.datatypes.generated.Uint256(_dues), 
                new org.web3j.abi.datatypes.Utf8String(_mvoID)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> deleteMVOPool(BigInteger _miningPoolId, String _mvoID) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_DELETEMVOPOOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_miningPoolId), 
                new org.web3j.abi.datatypes.Utf8String(_mvoID)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateMVOPoolMembership(BigInteger _newMiningPoolId, String _mvoID) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEMVOPOOLMEMBERSHIP, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_newMiningPoolId), 
                new org.web3j.abi.datatypes.Utf8String(_mvoID)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateCodeHash(byte[] _newCodeHash) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATECODEHASH, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Bytes32(_newCodeHash)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateMvoStatus(String _mvoID, MVO _mvo) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEMVOSTATUS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_mvoID), 
                _mvo), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateMinStake(BigInteger _newMinStake) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEMINSTAKE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_newMinStake)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateProtocol(String _newProtocol) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEPROTOCOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newProtocol)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updatePointsBot(String _newBot) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEPOINTSBOT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newBot)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    @Deprecated
    public static MVOStaking load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new MVOStaking(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static MVOStaking load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new MVOStaking(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static MVOStaking load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new MVOStaking(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static MVOStaking load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new MVOStaking(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<MVOStaking> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, BigInteger initialWeiValue, String _enshroudProtocol, String _enshroudToken, String _timelockManager, BigInteger _minStake) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_enshroudProtocol), 
                new org.web3j.abi.datatypes.Address(_enshroudToken), 
                new org.web3j.abi.datatypes.Address(_timelockManager), 
                new org.web3j.abi.datatypes.generated.Uint256(_minStake)));
        return deployRemoteCall(MVOStaking.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor, initialWeiValue);
    }

    public static RemoteCall<MVOStaking> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, BigInteger initialWeiValue, String _enshroudProtocol, String _enshroudToken, String _timelockManager, BigInteger _minStake) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_enshroudProtocol), 
                new org.web3j.abi.datatypes.Address(_enshroudToken), 
                new org.web3j.abi.datatypes.Address(_timelockManager), 
                new org.web3j.abi.datatypes.generated.Uint256(_minStake)));
        return deployRemoteCall(MVOStaking.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor, initialWeiValue);
    }

    @Deprecated
    public static RemoteCall<MVOStaking> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue, String _enshroudProtocol, String _enshroudToken, String _timelockManager, BigInteger _minStake) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_enshroudProtocol), 
                new org.web3j.abi.datatypes.Address(_enshroudToken), 
                new org.web3j.abi.datatypes.Address(_timelockManager), 
                new org.web3j.abi.datatypes.generated.Uint256(_minStake)));
        return deployRemoteCall(MVOStaking.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor, initialWeiValue);
    }

    @Deprecated
    public static RemoteCall<MVOStaking> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue, String _enshroudProtocol, String _enshroudToken, String _timelockManager, BigInteger _minStake) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_enshroudProtocol), 
                new org.web3j.abi.datatypes.Address(_enshroudToken), 
                new org.web3j.abi.datatypes.Address(_timelockManager), 
                new org.web3j.abi.datatypes.generated.Uint256(_minStake)));
        return deployRemoteCall(MVOStaking.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor, initialWeiValue);
    }

    protected String getStaticDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static String getPreviouslyDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static class MVO extends DynamicStruct {
        public String listenURI;

        public String stakingAddress;

        public String signingAddress;

        public String encrPubkey;

        public BigInteger stakingQuantum;

        public BigInteger memberPoolId;

        public BigInteger rating;

        public Boolean active;

        public MVO(String listenURI, String stakingAddress, String signingAddress, String encrPubkey, BigInteger stakingQuantum, BigInteger memberPoolId, BigInteger rating, Boolean active) {
            super(new org.web3j.abi.datatypes.Utf8String(listenURI), 
                    new org.web3j.abi.datatypes.Address(stakingAddress), 
                    new org.web3j.abi.datatypes.Address(signingAddress), 
                    new org.web3j.abi.datatypes.Utf8String(encrPubkey), 
                    new org.web3j.abi.datatypes.generated.Uint256(stakingQuantum), 
                    new org.web3j.abi.datatypes.generated.Uint120(memberPoolId), 
                    new org.web3j.abi.datatypes.generated.Uint120(rating), 
                    new org.web3j.abi.datatypes.Bool(active));
            this.listenURI = listenURI;
            this.stakingAddress = stakingAddress;
            this.signingAddress = signingAddress;
            this.encrPubkey = encrPubkey;
            this.stakingQuantum = stakingQuantum;
            this.memberPoolId = memberPoolId;
            this.rating = rating;
            this.active = active;
        }

        public MVO(Utf8String listenURI, Address stakingAddress, Address signingAddress, Utf8String encrPubkey, Uint256 stakingQuantum, Uint120 memberPoolId, Uint120 rating, Bool active) {
            super(listenURI, stakingAddress, signingAddress, encrPubkey, stakingQuantum, memberPoolId, rating, active);
            this.listenURI = listenURI.getValue();
            this.stakingAddress = stakingAddress.getValue();
            this.signingAddress = signingAddress.getValue();
            this.encrPubkey = encrPubkey.getValue();
            this.stakingQuantum = stakingQuantum.getValue();
            this.memberPoolId = memberPoolId.getValue();
            this.rating = rating.getValue();
            this.active = active.getValue();
        }
    }

    public static class CodeHashChangedEventResponse extends BaseEventResponse {
        public byte[] newCodeHash;
    }

    public static class MVOPoolCreatedEventResponse extends BaseEventResponse {
        public BigInteger poolId;

        public BigInteger dues;

        public String creatorMvoID;
    }

    public static class MVOPoolDeletedEventResponse extends BaseEventResponse {
        public BigInteger poolId;

        public String creatorMvoID;
    }

    public static class MVOStakeUpdatedEventResponse extends BaseEventResponse {
        public String mvoID;

        public BigInteger stakingQuantum;
    }

    public static class MVOStaking_ProtocolUpdatedEventResponse extends BaseEventResponse {
        public String newProtocol;
    }

    public static class MVOStaking_StakedEventResponse extends BaseEventResponse {
        public String sender;

        public BigInteger amount;

        public BigInteger blockNumber;
    }

    public static class MVOStaking_UnstakedEventResponse extends BaseEventResponse {
        public String sender;

        public BigInteger amount;

        public BigInteger blockNumber;
    }

    public static class MVOStatusChangedEventResponse extends BaseEventResponse {
        public String mvoID;

        public MVO updatedMVO;

        public BigInteger chainId;
    }

    public static class MinimumStakeUpdatedEventResponse extends BaseEventResponse {
        public BigInteger newMinStake;
    }

    public static class PointsAwardedEventResponse extends BaseEventResponse {
        public String mvoAddress;

        public BigInteger points;

        public BigInteger chainId;
    }

    public static class PointsBotUpdatedEventResponse extends BaseEventResponse {
        public String botAddress;
    }

    public static class PointsReducedEventResponse extends BaseEventResponse {
        public String mvoAddress;

        public BigInteger points;
    }

    public static class PoolMembershipUpdatedEventResponse extends BaseEventResponse {
        public BigInteger newPoolId;

        public BigInteger oldPoolId;

        public String memberMvoID;
    }
}
