#!/bin/bash

# script to start Enshroud AUD Jetty server as a daemon
### BEGIN INIT INFO
# Provides:			enshroud-aud
# Required-Start:	mariadb wg-quick.target
# Required-Stop:	mariadb wg-quick.target
# Should-Start:
# Should-Stop:
# X-Start-Before:
# X-Stop-After:
# Default-Start: 2 3 4 5
# Default-Stop: 0 1 6
# X-Interactive:  false
# Short-Description: starts/stops Enshroud AUD server
# Description:    starts/stops Enshroud AUD server
### END INIT INFO

export ENSHROUD_HOME=/var/lib/enshroud
# NB: set this user to the non-privileged user which runs the AUD (e.g. aud002)
export ENSHROUD_USER=audNNN

execCommand() {
	OLD_PWD=`pwd`
	cd $ENSHROUD_HOME
	CMD="./startAUD.sh"
	su -c "$CMD" $ENSHROUD_USER &
	sleep 1 # allows prompt to return
	cd $OLD_PWD
}

start() {
	execCommand
}

stop() {
	pid=$(pgrep -u $ENSHROUD_USER -f cc.enshroud.jetty.aud.AUD)
	if [ "$pid" != "" ] ; then
		kill -15 $pid
		echo "Enshroud AUD daemon stopped"
	else
		echo "Enshroud AUD daemon is not running"
	fi
}

case "$1" in
	start)
		start
		;;

	stop)
		stop
		;;

	restart)
		stop
		sleep 5
		start
		;;

	status)
		retval=$(pgrep -u $ENSHROUD_USER -f cc.enshroud.jetty.aud.AUD > /dev/null; echo $?)
		if [ "$retval" = "0" ] ; then
			echo "Enshroud AUD daemon is running"
		else
			echo "Enshroud AUD daemon is not running"
		fi
		;;

	*)
		echo "Usage: $0 {start|stop|restart|status}"
		exit 1
		;;
esac
exit 0

