/*
 * last modified---
 * 	03-14-23 relocate from aud.db
 * 	09-22-22 new
 *
 * purpose---
 * 	define exception class for the Enshroud database interface
 */

package cc.enshroud.jetty.db;


/**
 * exception class to handle errors in Enshroud database access methods
 */
public class EnshDbException extends Exception {
	// data members
	/**
	 * the error message text
	 */
	public String	m_DbError;

	/**
	 * the SQL statement which generated the error
	 */
	public String	m_DbStmt;

	/**
	 * the database error code
	 */
	public int		m_DbErrCode;

	// methods
	/**
	 * constructor
	 * @param dbError error string as returned by underlying database
	 * @param dbStmt the SQL statement or other command used to access the DB
	 * @param dbCode the error code returned by the underlying database
	 */
	public EnshDbException(String dbError, String dbStmt, int dbCode) {
		// pass up to superclass as one aggregation
		super("Ensh DB error " + dbError
				+ (dbStmt == null ? "" : (" on stmt " + dbStmt))
				+ (dbCode == 0 ? "" : (" err code " + dbCode)));
		// record
		m_DbError = dbError;
		m_DbStmt = dbStmt;
		m_DbErrCode = dbCode;
	}

	/**
	 * two-arg constructor (without error code)
	 * @param dbError error string as returned by underlying database
	 * @param dbStmt the SQL statement or other command used to access the DB
	 */
	public EnshDbException(String dbError, String dbStmt) {
		this(dbError, dbStmt, 0);
	}

	/**
	 * two-arg constructor (without statement)
	 * @param dbError error string as returned by underlying database
	 * @param dbCode the error code returned by the underlying database
	 */
	public EnshDbException(String dbError, int dbCode) {
		this(dbError, "", dbCode);
	}

	/**
	 * one-arg constructor (with just error string)
	 * @param dbError error string as returned by underlying database
	 */
	public EnshDbException(String dbError) {
		this(dbError, "", 0);
	}

	/**
	 * no-arg constructor
	 */
	public EnshDbException() {
		super("Unknown Ensh DB error");
	}
}
