/*
 * last modified---
 * 	09-26-22 new
 *
 * purpose--
 * 	provide a Java bean for a record in the ENSH_ENFT_KEYS or ENSH_RECEIPT_KEYS
 * 	tables
 */

package cc.enshroud.jetty.aud.db;


/**
 * This class supplies an instantiation of a row in either the ENSH_ENFT_KEYS or
 * ENSH_RECEIPT_KEYS tables.  It has bean methods to get and set all fields.
 */
public final class AESKey {
	// BEGIN data members
	/**
	 * the hash, always composed of keccak256(chainId+ID+ownerAddress)
	 */
	private String		m_Hash;

	/**
	 * the AES-256 key, in Base64Utf-encoded format
	 */
	private String		m_Key;

	// END data members

	// BEGIN methods
	/**
	 * constructor
	 * @param hash the hash value (non-null)
	 * @param key the key value (non-null)
	 */
	public AESKey(String hash, String key) {
		this();
		setHash(hash);
		setKey(key);
	}

	/**
	 * nullary constructor
	 */
	public AESKey() {
		m_Hash = m_Key = "";
	}

	// GET methods
	/**
	 * fetch the hash
	 * @return the hash value
	 */
	public String getHash() { return m_Hash; }

	/**
	 * fetch the key
	 * @return the key value
	 */
	public String getKey() { return m_Key; }


	// SET methods
	/**
	 * set the hash
	 * @param hash the hash value
	 */
	public void setHash(String hash) {
		if (hash != null) {
			m_Hash = hash;
		}
	}

	/**
	 * set the key
	 * @param key the key value
	 */
	public void setKey(String key) {
		if (key != null) {
			m_Key = key;
		}
	}

	// END methods
}
