/*
 * last modified---
 * 	02-22-23 add m_ArgsSig and findMVOSig()
 * 	03-25-22 new
 *
 * purpose---
 * 	represent the signature of an MVO in any context
 */

package cc.enshroud.jetty;

import java.util.ArrayList;


/**
 * This class holds the public data necessary to describe MVO signatures.
 * It provides a static method to search an ArrayList for a given MVO's sig.
 */
public final class MVOSignature {
	/**
	 * the signature sequence number, if any (001, 002, etc.)
	 */
	public String		m_Sequence;

	/**
	 * the signer (the ID of the MVO who signs)
	 */
	public String		m_Signer;

	/**
	 * the actual signature, in 130-char hex digest format
	 */
	public String		m_Signature;

	/**
	 * the signature on the arguments hash, in 130-char hex digest format
	 */
	public String		m_ArgsSig;

	/**
	 * nullary constructor
	 */
	public MVOSignature() {
		m_Sequence = m_Signer = m_Signature = m_ArgsSig = "";
	}

	/**
	 * method to find a particular MVO's signature in an array (first only)
	 * @param mvoId the desired MVO signature
	 * @param sigList an array of signatures to be searched
	 * @return the associated signature block, or null if not found
	 */
	public static MVOSignature findMVOSig(String mvoId,
										  ArrayList<MVOSignature> sigList)
	{
		if (mvoId == null || sigList == null || sigList.isEmpty()) {
			return null;
		}
		MVOSignature matchSig = null;
		for (MVOSignature sig : sigList) {
			if (sig.m_Signer.equals(mvoId)) {
				matchSig = sig;
				// we assume this will be the only such match
				break;
			}
		}
		return matchSig;
	}
}
