package cc.enshroud.jetty.wrappers;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.FunctionEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Bytes32;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

/**
 * <p>Auto generated code.
 * <p><strong>Do not modify!</strong>
 * <p>Please use the <a href="https://docs.web3j.io/command_line.html">web3j command line tools</a>,
 * or the org.web3j.codegen.SolidityFunctionWrapperGenerator in the 
 * <a href="https://github.com/web3j/web3j/tree/master/codegen">codegen module</a> to update.
 *
 * <p>Generated with web3j version 1.4.2.
 */
@SuppressWarnings("rawtypes")
public class EnshroudProtocol extends Contract {
    public static final String BINARY = "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";

    public static final String FUNC_ADMINSTATUS = "adminStatus";

    public static final String FUNC_ASSETBALANCES = "assetBalances";

    public static final String FUNC_ASSETDEPOSITFEE = "assetDepositFee";

    public static final String FUNC_ASSETWITHDRAWFEE = "assetWithdrawFee";

    public static final String FUNC_AUDITORS = "auditors";

    public static final String FUNC_BALANCEOF = "balanceOf";

    public static final String FUNC_BASEURI = "baseURI";

    public static final String FUNC_CONFIRMATIONBLOCKS = "confirmationBlocks";

    public static final String FUNC_DAOPOOL = "daoPool";

    public static final String FUNC_ENFTUNLOCKTIME = "enftUnlockTime";

    public static final String FUNC_IDTOAUDITORGREYLIST = "idToAuditorGreylist";

    public static final String FUNC_ONERC1155BATCHRECEIVED = "onERC1155BatchReceived";

    public static final String FUNC_ONERC1155RECEIVED = "onERC1155Received";

    public static final String FUNC_REQUIREDSIGS = "requiredSigs";

    public static final String FUNC_SUPPORTSINTERFACE = "supportsInterface";

    public static final String FUNC_TREASURY = "treasury";

    public static final String FUNC_TREASURYFEE = "treasuryFee";

    public static final String FUNC_SETMVOSTAKINGADDRESS = "setMVOStakingAddress";

    public static final String FUNC_DEPOSITETH = "depositEth";

    public static final String FUNC_DEPOSITTOKENS = "depositTokens";

    public static final String FUNC_DEPOSITTOKENSWITHPERMIT = "depositTokensWithPermit";

    public static final String FUNC_MINTENFTSFROMDEPOSIT = "mintENFTsFromDeposit";

    public static final String FUNC_SPENDENFTS = "spendENFTs";

    public static final String FUNC_REDEEMENFTSANDWITHDRAW = "redeemENFTsAndWithdraw";

    public static final String FUNC_AUDITORGREYLIST = "auditorGreyList";

    public static final String FUNC_REMOVEGREYLISTSTATUS = "removeGreylistStatus";

    public static final String FUNC_UPDATEAUDITOR = "updateAuditor";

    public static final String FUNC_UPDATEFEES = "updateFees";

    public static final String FUNC_UPDATEADMIN = "updateAdmin";

    public static final String FUNC_UPDATETREASURY = "updateTreasury";

    public static final String FUNC_UPDATEDAOPOOL = "updateDaoPool";

    public static final String FUNC_URI = "uri";

    public static final Event ADMINUPDATED_EVENT = new Event("AdminUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Bool>() {}));
    ;

    public static final Event AUDITORUPDATED_EVENT = new Event("AuditorUpdated", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}, new TypeReference<Utf8String>() {}));
    ;

    public static final Event DEPOSITERC20_EVENT = new Event("DepositERC20", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event DEPOSITETH_EVENT = new Event("DepositETH", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event GREYLISTADD_EVENT = new Event("GreyListAdd", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<DynamicArray<Uint256>>() {}));
    ;

    public static final Event GREYLISTDELETION_EVENT = new Event("GreyListDeletion", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
    ;

    public static final Event TRANSFERSINGLE_EVENT = new Event("TransferSingle", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event URI_EVENT = new Event("URI", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}, new TypeReference<Uint256>(true) {}));
    ;

    public static final Event WITHDRAWERC20_EVENT = new Event("WithdrawERC20", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Address>() {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    public static final Event WITHDRAWETH_EVENT = new Event("WithdrawETH", 
            Arrays.<TypeReference<?>>asList(new TypeReference<Address>(true) {}, new TypeReference<Uint256>() {}, new TypeReference<Uint256>() {}));
    ;

    protected static final HashMap<String, String> _addresses;

    static {
        _addresses = new HashMap<String, String>();
        _addresses.put("1337", "0x3A125bE5bB8A3E1C171947c384795B4a488B74A0");
        _addresses.put("1", "0x6aea2e04f281eC4eA01222dcC44Be6A30281EAb7");
        _addresses.put("11155111", "0xc353a083050bFF5c89cD123B827fDd6a0314Ac8a");
    }

    @Deprecated
    protected EnshroudProtocol(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected EnshroudProtocol(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected EnshroudProtocol(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected EnshroudProtocol(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static List<AdminUpdatedEventResponse> getAdminUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(ADMINUPDATED_EVENT, transactionReceipt);
        ArrayList<AdminUpdatedEventResponse> responses = new ArrayList<AdminUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AdminUpdatedEventResponse typedResponse = new AdminUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.admin = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.status = (Boolean) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AdminUpdatedEventResponse> adminUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, AdminUpdatedEventResponse>() {
            @Override
            public AdminUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(ADMINUPDATED_EVENT, log);
                AdminUpdatedEventResponse typedResponse = new AdminUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.admin = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.status = (Boolean) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AdminUpdatedEventResponse> adminUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(ADMINUPDATED_EVENT));
        return adminUpdatedEventFlowable(filter);
    }

    public static List<AuditorUpdatedEventResponse> getAuditorUpdatedEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(AUDITORUPDATED_EVENT, transactionReceipt);
        ArrayList<AuditorUpdatedEventResponse> responses = new ArrayList<AuditorUpdatedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AuditorUpdatedEventResponse typedResponse = new AuditorUpdatedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.auditor = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.audId = (String) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AuditorUpdatedEventResponse> auditorUpdatedEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, AuditorUpdatedEventResponse>() {
            @Override
            public AuditorUpdatedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(AUDITORUPDATED_EVENT, log);
                AuditorUpdatedEventResponse typedResponse = new AuditorUpdatedEventResponse();
                typedResponse.log = log;
                typedResponse.auditor = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.audId = (String) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AuditorUpdatedEventResponse> auditorUpdatedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(AUDITORUPDATED_EVENT));
        return auditorUpdatedEventFlowable(filter);
    }

    public static List<DepositERC20EventResponse> getDepositERC20Events(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(DEPOSITERC20_EVENT, transactionReceipt);
        ArrayList<DepositERC20EventResponse> responses = new ArrayList<DepositERC20EventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositERC20EventResponse typedResponse = new DepositERC20EventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.tokenContract = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositERC20EventResponse> depositERC20EventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, DepositERC20EventResponse>() {
            @Override
            public DepositERC20EventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DEPOSITERC20_EVENT, log);
                DepositERC20EventResponse typedResponse = new DepositERC20EventResponse();
                typedResponse.log = log;
                typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.tokenContract = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositERC20EventResponse> depositERC20EventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DEPOSITERC20_EVENT));
        return depositERC20EventFlowable(filter);
    }

    public static List<DepositETHEventResponse> getDepositETHEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(DEPOSITETH_EVENT, transactionReceipt);
        ArrayList<DepositETHEventResponse> responses = new ArrayList<DepositETHEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositETHEventResponse typedResponse = new DepositETHEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.weiAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositETHEventResponse> depositETHEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, DepositETHEventResponse>() {
            @Override
            public DepositETHEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(DEPOSITETH_EVENT, log);
                DepositETHEventResponse typedResponse = new DepositETHEventResponse();
                typedResponse.log = log;
                typedResponse.sender = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.weiAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositETHEventResponse> depositETHEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(DEPOSITETH_EVENT));
        return depositETHEventFlowable(filter);
    }

	@SuppressWarnings("unchecked")
    public static List<GreyListAddEventResponse> getGreyListAddEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(GREYLISTADD_EVENT, transactionReceipt);
        ArrayList<GreyListAddEventResponse> responses = new ArrayList<GreyListAddEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            GreyListAddEventResponse typedResponse = new GreyListAddEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.audId = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.ids = (List<BigInteger>) ((Array) eventValues.getNonIndexedValues().get(1)).getNativeValueCopy();
            responses.add(typedResponse);
        }
        return responses;
    }

	@SuppressWarnings("unchecked")
    public Flowable<GreyListAddEventResponse> greyListAddEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, GreyListAddEventResponse>() {
            @Override
            public GreyListAddEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(GREYLISTADD_EVENT, log);
                GreyListAddEventResponse typedResponse = new GreyListAddEventResponse();
                typedResponse.log = log;
                typedResponse.audId = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.ids = (List<BigInteger>) ((Array) eventValues.getNonIndexedValues().get(1)).getNativeValueCopy();
                return typedResponse;
            }
        });
    }

    public Flowable<GreyListAddEventResponse> greyListAddEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(GREYLISTADD_EVENT));
        return greyListAddEventFlowable(filter);
    }

    public static List<GreyListDeletionEventResponse> getGreyListDeletionEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(GREYLISTDELETION_EVENT, transactionReceipt);
        ArrayList<GreyListDeletionEventResponse> responses = new ArrayList<GreyListDeletionEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            GreyListDeletionEventResponse typedResponse = new GreyListDeletionEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<GreyListDeletionEventResponse> greyListDeletionEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, GreyListDeletionEventResponse>() {
            @Override
            public GreyListDeletionEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(GREYLISTDELETION_EVENT, log);
                GreyListDeletionEventResponse typedResponse = new GreyListDeletionEventResponse();
                typedResponse.log = log;
                typedResponse.id = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<GreyListDeletionEventResponse> greyListDeletionEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(GREYLISTDELETION_EVENT));
        return greyListDeletionEventFlowable(filter);
    }

    public static List<TransferSingleEventResponse> getTransferSingleEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(TRANSFERSINGLE_EVENT, transactionReceipt);
        ArrayList<TransferSingleEventResponse> responses = new ArrayList<TransferSingleEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.operator = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.from = (String) eventValues.getIndexedValues().get(1).getValue();
            typedResponse.to = (String) eventValues.getIndexedValues().get(2).getValue();
            typedResponse.id = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, TransferSingleEventResponse>() {
            @Override
            public TransferSingleEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(TRANSFERSINGLE_EVENT, log);
                TransferSingleEventResponse typedResponse = new TransferSingleEventResponse();
                typedResponse.log = log;
                typedResponse.operator = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.from = (String) eventValues.getIndexedValues().get(1).getValue();
                typedResponse.to = (String) eventValues.getIndexedValues().get(2).getValue();
                typedResponse.id = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferSingleEventResponse> transferSingleEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(TRANSFERSINGLE_EVENT));
        return transferSingleEventFlowable(filter);
    }

    public static List<URIEventResponse> getURIEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(URI_EVENT, transactionReceipt);
        ArrayList<URIEventResponse> responses = new ArrayList<URIEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            URIEventResponse typedResponse = new URIEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.id = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.value = (String) eventValues.getNonIndexedValues().get(0).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<URIEventResponse> uRIEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, URIEventResponse>() {
            @Override
            public URIEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(URI_EVENT, log);
                URIEventResponse typedResponse = new URIEventResponse();
                typedResponse.log = log;
                typedResponse.id = (BigInteger) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.value = (String) eventValues.getNonIndexedValues().get(0).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<URIEventResponse> uRIEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(URI_EVENT));
        return uRIEventFlowable(filter);
    }

    public static List<WithdrawERC20EventResponse> getWithdrawERC20Events(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(WITHDRAWERC20_EVENT, transactionReceipt);
        ArrayList<WithdrawERC20EventResponse> responses = new ArrayList<WithdrawERC20EventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawERC20EventResponse typedResponse = new WithdrawERC20EventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.withdrawer = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.tokenContract = (String) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<WithdrawERC20EventResponse> withdrawERC20EventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, WithdrawERC20EventResponse>() {
            @Override
            public WithdrawERC20EventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(WITHDRAWERC20_EVENT, log);
                WithdrawERC20EventResponse typedResponse = new WithdrawERC20EventResponse();
                typedResponse.log = log;
                typedResponse.withdrawer = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.tokenContract = (String) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.amount = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(2).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<WithdrawERC20EventResponse> withdrawERC20EventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(WITHDRAWERC20_EVENT));
        return withdrawERC20EventFlowable(filter);
    }

    public static List<WithdrawETHEventResponse> getWithdrawETHEvents(TransactionReceipt transactionReceipt) {
        List<Contract.EventValuesWithLog> valueList = staticExtractEventParametersWithLog(WITHDRAWETH_EVENT, transactionReceipt);
        ArrayList<WithdrawETHEventResponse> responses = new ArrayList<WithdrawETHEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            WithdrawETHEventResponse typedResponse = new WithdrawETHEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.withdrawer = (String) eventValues.getIndexedValues().get(0).getValue();
            typedResponse.weiAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
            typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<WithdrawETHEventResponse> withdrawETHEventFlowable(EthFilter filter) {
        return web3j.ethLogFlowable(filter).map(new Function<Log, WithdrawETHEventResponse>() {
            @Override
            public WithdrawETHEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = extractEventParametersWithLog(WITHDRAWETH_EVENT, log);
                WithdrawETHEventResponse typedResponse = new WithdrawETHEventResponse();
                typedResponse.log = log;
                typedResponse.withdrawer = (String) eventValues.getIndexedValues().get(0).getValue();
                typedResponse.weiAmount = (BigInteger) eventValues.getNonIndexedValues().get(0).getValue();
                typedResponse.chainId = (BigInteger) eventValues.getNonIndexedValues().get(1).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<WithdrawETHEventResponse> withdrawETHEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, getContractAddress());
        filter.addSingleTopic(EventEncoder.encode(WITHDRAWETH_EVENT));
        return withdrawETHEventFlowable(filter);
    }

    public RemoteFunctionCall<Boolean> adminStatus(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADMINSTATUS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> assetBalances(String param0, String param1) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ASSETBALANCES, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0), 
                new org.web3j.abi.datatypes.Address(param1)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> assetDepositFee(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ASSETDEPOSITFEE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> assetWithdrawFee(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ASSETWITHDRAWFEE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> auditors(String param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_AUDITORS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String param0, BigInteger param1) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0), 
                new org.web3j.abi.datatypes.generated.Uint256(param1)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> baseURI() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BASEURI, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> confirmationBlocks() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_CONFIRMATIONBLOCKS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> daoPool() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DAOPOOL, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> enftUnlockTime(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ENFTUNLOCKTIME, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<String> idToAuditorGreylist(BigInteger param0) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_IDTOAUDITORGREYLIST, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(param0)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> onERC1155BatchReceived(String param0, String param1, List<BigInteger> param2, List<BigInteger> param3, byte[] param4) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_ONERC1155BATCHRECEIVED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0), 
                new org.web3j.abi.datatypes.Address(param1), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(param2, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(param3, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicBytes(param4)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> onERC1155Received(String param0, String param1, BigInteger param2, BigInteger param3, byte[] param4) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_ONERC1155RECEIVED, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(param0), 
                new org.web3j.abi.datatypes.Address(param1), 
                new org.web3j.abi.datatypes.generated.Uint256(param2), 
                new org.web3j.abi.datatypes.generated.Uint256(param3), 
                new org.web3j.abi.datatypes.DynamicBytes(param4)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> requiredSigs() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REQUIREDSIGS, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> supportsInterface(byte[] interfaceId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SUPPORTSINTERFACE, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Bytes4(interfaceId)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Bool>() {}));
        return executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<String> treasury() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TREASURY, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Address>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<BigInteger> treasuryFee() {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TREASURYFEE, 
                Arrays.<Type>asList(), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Uint256>() {}));
        return executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setMVOStakingAddress(String _mvoStaking) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SETMVOSTAKINGADDRESS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_mvoStaking)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> depositEth(String _depositor, BigInteger weiValue) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_DEPOSITETH, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_depositor)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function, weiValue);
    }

    public RemoteFunctionCall<TransactionReceipt> depositTokens(String _depositor, String _tokenContract, BigInteger _amount) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_DEPOSITTOKENS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_depositor), 
                new org.web3j.abi.datatypes.Address(_tokenContract), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> depositTokensWithPermit(String _tokenContract, String _depositor, BigInteger _amount, BigInteger _nonce, BigInteger _deadline, BigInteger v, byte[] r, byte[] s) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_DEPOSITTOKENSWITHPERMIT, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_tokenContract), 
                new org.web3j.abi.datatypes.Address(_depositor), 
                new org.web3j.abi.datatypes.generated.Uint256(_amount), 
                new org.web3j.abi.datatypes.generated.Uint256(_nonce), 
                new org.web3j.abi.datatypes.generated.Uint256(_deadline), 
                new org.web3j.abi.datatypes.generated.Uint8(v), 
                new org.web3j.abi.datatypes.generated.Bytes32(r), 
                new org.web3j.abi.datatypes.generated.Bytes32(s)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> mintENFTsFromDeposit(OpsInfo _opsInfo, MVOinfo _mvoInfo, String _tokenContract) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_MINTENFTSFROMDEPOSIT, 
                Arrays.<Type>asList(_opsInfo, 
                _mvoInfo, 
                new org.web3j.abi.datatypes.Address(_tokenContract)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> spendENFTs(OpsInfo _enftInfo, MVOinfo _mvoInfo) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_SPENDENFTS, 
                Arrays.<Type>asList(_enftInfo, 
                _mvoInfo), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> redeemENFTsAndWithdraw(OpsInfo _opsInfo, MVOinfo _mvoInfo, List<BigInteger> _amounts, List<byte[]> _rand, String _tokenContract) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REDEEMENFTSANDWITHDRAW, 
                Arrays.<Type>asList(_opsInfo, 
                _mvoInfo, 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_amounts, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Bytes16>(
                        org.web3j.abi.datatypes.generated.Bytes16.class,
                        org.web3j.abi.Utils.typeMap(_rand, org.web3j.abi.datatypes.generated.Bytes16.class)), 
                new org.web3j.abi.datatypes.Address(_tokenContract)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> auditorGreyList(String _audId, List<BigInteger> _ids, List<String> _reasons) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_AUDITORGREYLIST, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_audId), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                        org.web3j.abi.datatypes.generated.Uint256.class,
                        org.web3j.abi.Utils.typeMap(_ids, org.web3j.abi.datatypes.generated.Uint256.class)), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                        org.web3j.abi.datatypes.Utf8String.class,
                        org.web3j.abi.Utils.typeMap(_reasons, org.web3j.abi.datatypes.Utf8String.class))), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> removeGreylistStatus(BigInteger _id) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_REMOVEGREYLISTSTATUS, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.generated.Uint256(_id)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateAuditor(String _addr, String _audId) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEAUDITOR, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_addr), 
                new org.web3j.abi.datatypes.Utf8String(_audId)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateFees(String _tokenAddr, BigInteger _newDepositFee, BigInteger _newWithdrawFee) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEFEES, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_tokenAddr), 
                new org.web3j.abi.datatypes.generated.Uint256(_newDepositFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_newWithdrawFee)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateAdmin(String _addr, Boolean _status) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEADMIN, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_addr), 
                new org.web3j.abi.datatypes.Bool(_status)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateTreasury(String _newTreasury) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATETREASURY, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newTreasury)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> updateDaoPool(String _newDaoPool) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(
                FUNC_UPDATEDAOPOOL, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_newDaoPool)), 
                Collections.<TypeReference<?>>emptyList());
        return executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> uri(String _metadata) {
        final org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_URI, 
                Arrays.<Type>asList(new org.web3j.abi.datatypes.Utf8String(_metadata)), 
                Arrays.<TypeReference<?>>asList(new TypeReference<Utf8String>() {}));
        return executeRemoteCallSingleValueReturn(function, String.class);
    }

    @Deprecated
    public static EnshroudProtocol load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new EnshroudProtocol(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static EnshroudProtocol load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new EnshroudProtocol(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static EnshroudProtocol load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new EnshroudProtocol(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static EnshroudProtocol load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new EnshroudProtocol(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<EnshroudProtocol> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider, BigInteger initialWeiValue, String _treasury, String _weth, String _dai, List<String> _initialAdmins, BigInteger _depositFee, BigInteger _withdrawFee, BigInteger _requiredSigs, BigInteger _confBlocks, String _baseUri) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_treasury), 
                new org.web3j.abi.datatypes.Address(_weth), 
                new org.web3j.abi.datatypes.Address(_dai), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Address>(
                        org.web3j.abi.datatypes.Address.class,
                        org.web3j.abi.Utils.typeMap(_initialAdmins, org.web3j.abi.datatypes.Address.class)), 
                new org.web3j.abi.datatypes.generated.Uint256(_depositFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_withdrawFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_requiredSigs), 
                new org.web3j.abi.datatypes.generated.Uint256(_confBlocks), 
                new org.web3j.abi.datatypes.Utf8String(_baseUri)));
        return deployRemoteCall(EnshroudProtocol.class, web3j, credentials, contractGasProvider, BINARY, encodedConstructor, initialWeiValue);
    }

    public static RemoteCall<EnshroudProtocol> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider, BigInteger initialWeiValue, String _treasury, String _weth, String _dai, List<String> _initialAdmins, BigInteger _depositFee, BigInteger _withdrawFee, BigInteger _requiredSigs, BigInteger _confBlocks, String _baseUri) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_treasury), 
                new org.web3j.abi.datatypes.Address(_weth), 
                new org.web3j.abi.datatypes.Address(_dai), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Address>(
                        org.web3j.abi.datatypes.Address.class,
                        org.web3j.abi.Utils.typeMap(_initialAdmins, org.web3j.abi.datatypes.Address.class)), 
                new org.web3j.abi.datatypes.generated.Uint256(_depositFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_withdrawFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_requiredSigs), 
                new org.web3j.abi.datatypes.generated.Uint256(_confBlocks), 
                new org.web3j.abi.datatypes.Utf8String(_baseUri)));
        return deployRemoteCall(EnshroudProtocol.class, web3j, transactionManager, contractGasProvider, BINARY, encodedConstructor, initialWeiValue);
    }

    @Deprecated
    public static RemoteCall<EnshroudProtocol> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue, String _treasury, String _weth, String _dai, List<String> _initialAdmins, BigInteger _depositFee, BigInteger _withdrawFee, BigInteger _requiredSigs, BigInteger _confBlocks, String _baseUri) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_treasury), 
                new org.web3j.abi.datatypes.Address(_weth), 
                new org.web3j.abi.datatypes.Address(_dai), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Address>(
                        org.web3j.abi.datatypes.Address.class,
                        org.web3j.abi.Utils.typeMap(_initialAdmins, org.web3j.abi.datatypes.Address.class)), 
                new org.web3j.abi.datatypes.generated.Uint256(_depositFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_withdrawFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_requiredSigs), 
                new org.web3j.abi.datatypes.generated.Uint256(_confBlocks), 
                new org.web3j.abi.datatypes.Utf8String(_baseUri)));
        return deployRemoteCall(EnshroudProtocol.class, web3j, credentials, gasPrice, gasLimit, BINARY, encodedConstructor, initialWeiValue);
    }

    @Deprecated
    public static RemoteCall<EnshroudProtocol> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit, BigInteger initialWeiValue, String _treasury, String _weth, String _dai, List<String> _initialAdmins, BigInteger _depositFee, BigInteger _withdrawFee, BigInteger _requiredSigs, BigInteger _confBlocks, String _baseUri) {
        String encodedConstructor = FunctionEncoder.encodeConstructor(Arrays.<Type>asList(new org.web3j.abi.datatypes.Address(_treasury), 
                new org.web3j.abi.datatypes.Address(_weth), 
                new org.web3j.abi.datatypes.Address(_dai), 
                new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Address>(
                        org.web3j.abi.datatypes.Address.class,
                        org.web3j.abi.Utils.typeMap(_initialAdmins, org.web3j.abi.datatypes.Address.class)), 
                new org.web3j.abi.datatypes.generated.Uint256(_depositFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_withdrawFee), 
                new org.web3j.abi.datatypes.generated.Uint256(_requiredSigs), 
                new org.web3j.abi.datatypes.generated.Uint256(_confBlocks), 
                new org.web3j.abi.datatypes.Utf8String(_baseUri)));
        return deployRemoteCall(EnshroudProtocol.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, encodedConstructor, initialWeiValue);
    }

    protected String getStaticDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static String getPreviouslyDeployedAddress(String networkId) {
        return _addresses.get(networkId);
    }

    public static class OpsInfo extends DynamicStruct {
        public List<String> recipients;

        public List<byte[]> detailsHashes;

        public List<BigInteger> inputIds;

        public List<BigInteger> outputIds;

        public List<String> metadata;

        public BigInteger amount;

        public byte[] obHash;

        public OpsInfo(List<String> recipients, List<byte[]> detailsHashes, List<BigInteger> inputIds, List<BigInteger> outputIds, List<String> metadata, BigInteger amount, byte[] obHash) {
            super(new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Address>(
                            org.web3j.abi.datatypes.Address.class,
                            org.web3j.abi.Utils.typeMap(recipients, org.web3j.abi.datatypes.Address.class)), 
                    new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Bytes32>(
                            org.web3j.abi.datatypes.generated.Bytes32.class,
                            org.web3j.abi.Utils.typeMap(detailsHashes, org.web3j.abi.datatypes.generated.Bytes32.class)), 
                    new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                            org.web3j.abi.datatypes.generated.Uint256.class,
                            org.web3j.abi.Utils.typeMap(inputIds, org.web3j.abi.datatypes.generated.Uint256.class)), 
                    new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.generated.Uint256>(
                            org.web3j.abi.datatypes.generated.Uint256.class,
                            org.web3j.abi.Utils.typeMap(outputIds, org.web3j.abi.datatypes.generated.Uint256.class)), 
                    new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                            org.web3j.abi.datatypes.Utf8String.class,
                            org.web3j.abi.Utils.typeMap(metadata, org.web3j.abi.datatypes.Utf8String.class)), 
                    new org.web3j.abi.datatypes.generated.Uint256(amount), 
                    new org.web3j.abi.datatypes.generated.Bytes32(obHash));
            this.recipients = recipients;
            this.detailsHashes = detailsHashes;
            this.inputIds = inputIds;
            this.outputIds = outputIds;
            this.metadata = metadata;
            this.amount = amount;
            this.obHash = obHash;
        }

        public OpsInfo(DynamicArray<Address> recipients, DynamicArray<Bytes32> detailsHashes, DynamicArray<Uint256> inputIds, DynamicArray<Uint256> outputIds, DynamicArray<Utf8String> metadata, Uint256 amount, Bytes32 obHash) {
            super(recipients, detailsHashes, inputIds, outputIds, metadata, amount, obHash);
            this.recipients = recipients.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
            this.detailsHashes = detailsHashes.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
            this.inputIds = inputIds.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
            this.outputIds = outputIds.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
            this.metadata = metadata.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
            this.amount = amount.getValue();
            this.obHash = obHash.getValue();
        }
    }

    public static class MVOinfo extends DynamicStruct {
        public List<byte[]> mvoSigs;

        public List<String> mvoIDs;

        public MVOinfo(List<byte[]> mvoSigs, List<String> mvoIDs) {
            super(new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.DynamicBytes>(
                            org.web3j.abi.datatypes.DynamicBytes.class,
                            org.web3j.abi.Utils.typeMap(mvoSigs, org.web3j.abi.datatypes.DynamicBytes.class)), 
                    new org.web3j.abi.datatypes.DynamicArray<org.web3j.abi.datatypes.Utf8String>(
                            org.web3j.abi.datatypes.Utf8String.class,
                            org.web3j.abi.Utils.typeMap(mvoIDs, org.web3j.abi.datatypes.Utf8String.class)));
            this.mvoSigs = mvoSigs;
            this.mvoIDs = mvoIDs;
        }

        public MVOinfo(DynamicArray<DynamicBytes> mvoSigs, DynamicArray<Utf8String> mvoIDs) {
            super(mvoSigs, mvoIDs);
            this.mvoSigs = mvoSigs.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
            this.mvoIDs = mvoIDs.getValue().stream().map(v -> v.getValue()).collect(Collectors.toList());
        }
    }

    public static class AdminUpdatedEventResponse extends BaseEventResponse {
        public String admin;

        public Boolean status;
    }

    public static class AuditorUpdatedEventResponse extends BaseEventResponse {
        public String auditor;

        public String audId;
    }

    public static class DepositERC20EventResponse extends BaseEventResponse {
        public String sender;

        public String tokenContract;

        public BigInteger amount;

        public BigInteger chainId;
    }

    public static class DepositETHEventResponse extends BaseEventResponse {
        public String sender;

        public BigInteger weiAmount;

        public BigInteger chainId;
    }

    public static class GreyListAddEventResponse extends BaseEventResponse {
        public String audId;

        public List<BigInteger> ids;
    }

    public static class GreyListDeletionEventResponse extends BaseEventResponse {
        public BigInteger id;
    }

    public static class TransferSingleEventResponse extends BaseEventResponse {
        public String operator;

        public String from;

        public String to;

        public BigInteger id;

        public BigInteger amount;
    }

    public static class URIEventResponse extends BaseEventResponse {
        public BigInteger id;

        public String value;
    }

    public static class WithdrawERC20EventResponse extends BaseEventResponse {
        public String withdrawer;

        public String tokenContract;

        public BigInteger amount;

        public BigInteger chainId;
    }

    public static class WithdrawETHEventResponse extends BaseEventResponse {
        public String withdrawer;

        public BigInteger weiAmount;

        public BigInteger chainId;
    }
}
