/*
 * last modified---
 * 	04-05-23 add index (OWNER, CHAIN_ID)
 * 	03-14-23 new
 *
 * purpose---
 * 	schema for an Enshroud MVO's internal database (used for storing receipts)
 */

use enshroud;

drop table if exists ENSH_RECEIPT_STORAGE;

/* table for records representing receipts */
create table ENSH_RECEIPT_STORAGE (
	/* the ID of the receipt */
	RECEIPT_ID		varchar(64) not null,

	/* the ID of the chain (per standard) on which the receipt was issued */
	CHAIN_ID		bigint not null,

	/* the SHA256 hash of the owner's address */
	OWNER			varchar(64) not null,

	/* the receipt JSON, AES-256 encrypted with the key stored in ENSH_ENFT_KEYS
	 * at index sha256(ID+chain+owner), in base64 format
	 */
	RECEIPT			text not null,

	/* index */
	unique index (RECEIPT_ID, CHAIN_ID),
	index (OWNER, CHAIN_ID)
	)	
\g
