/*
 * last modified---
 * 	03-15-23 new
 *
 * purpose---
 * 	provide a Java bean for a record in the ENSH_RECEIPT_STORAGE table
 */

package cc.enshroud.jetty.mvo.db;


/**
 * This class supplies an instantiation of a row in the ENSH_RECEIPT_STORAGE
 * table.  It has bean methods to get and set all fields.
 */
public final class ReceiptStorage {
	// BEGIN data members
	/**
	 * the unique ID, a zero-padded 64-digit hex number
	 */
	private String		m_ID;

	/**
	 * the chain ID on which the receipt was issued
	 */
	private long		m_Chain;

	/**
	 * the SHA256 hash of the wallet address that owns the receipt
	 */
	private String		m_Owner;

	/**
	 * the raw receipt data, details AES-encrypted and base64-encoded
	 */
	private String		m_Receipt;

	// END data members
	
	// BEGIN methods
	/**
	 * constructor
	 * @param Id the ID value assigned to the receipt (unique on its chain)
	 * @param chain the ID of the relevant blockchain
	 */
	public ReceiptStorage(String Id, long chain) {
		setID(Id);
		setChain(chain);
		m_Owner = m_Receipt = "";
	}

	// GET methods
	/**
	 * fetch the Id
	 * @return the Id of the receipt
	 */
	public String getID() { return m_ID; }

	/**
	 * fetch the chain ID
	 * @return the ID of the chain (per standards) where the receipt was created
	 */
	public long getChain() { return m_Chain; }

	/**
	 * fetch the owner
	 * @return the SHA256 hash of the address which owns this receipt
	 */
	public String getOwner() { return m_Owner; }

	/**
	 * fetch the (encrypted) text
	 * @return the base64-encoded encrypted receipt text, empty if not set
	 */
	public String getReceipt() { return m_Receipt; }


	// SET methods
	/**
	 * set the ID
	 * @param id the receipt ID value
	 */
	public void setID(String id) {
		if (id != null) {
			m_ID = id;
		}
	}

	/**
	 * set the chain Id
	 * @param chain the ID of the blockchain
	 */
	public void setChain(long chain) {
		if (chain > 0L) {
			m_Chain = chain;
		}
	}

	/**
	 * set the owner hash
	 * @param owner the SHA256 hash of the address that owns this receipt
	 */
	public void setOwner(String owner) {
		if (owner != null) {
			m_Owner = new String(owner);
		}
	}

	/**
	 * set the receipt text (separately)
	 * @param rctValue the encrypted and base64-encoded receipt text value
	 */
	public void setReceipt(String rctValue) {
		if (rctValue != null) {
			m_Receipt = new String(rctValue);
		}
	}

	// END methods
}
