/*
 * last modified---
 * 	03-14-23 relocate from aud.db
 * 	09-26-22 new
 *
 * purpose---
 * 	provide a base class containing database API components
 */

package cc.enshroud.jetty.db;

import cc.enshroud.jetty.log.Log;

import java.sql.Connection;
import java.sql.SQLException;


/**
 * This class supplies a base class containing common members and methods.
 * All database access classes must extend this class.
 */
public abstract class GenericDb {
	// BEGIN data members
	/**
	 * date format to use when formatting orders for database insertion
	 */
	public final String				M_DB_DATE_FMT = "dd-MMM-yyyy HH:mm:ss";

	/**
	 * name of the table in the database
	 */
	protected String				m_Table;

	/**
	 * the connection manager to use to obtain and release DB connections
	 */
	protected DbConnectionManager	m_DbManager;

	/**
	 * the logging object to use
	 */
	protected Log					m_Log;
	
	// END data members
	
	// BEGIN methods
	/**
	 * constructor
	 * @param manager the DB connection manager
	 * @param logger the error/debug logger
	 */
	public GenericDb(DbConnectionManager manager, Log logger) {
		m_DbManager = manager;
		m_Log = logger;
	}

	/**
	 * Obtain a database connection (always asks manager for a fresh one).
	 * Should be called immediately before use, to ensure that the connection
	 * is not stale.  This method catches and returns null on exceptions.
	 * @return the connection
	 */
	protected synchronized Connection getDbConnection() {
		Connection newConn = null;
		try {
			newConn = m_DbManager.getConnection();
		}
		catch (SQLException sqle) {
			m_Log.error("Could not get/configure DB connection", sqle);
		}
		return newConn;
	}

	// END methods
}
