/*
 * last modified---
 * 	10-11-22 add ENSH_ENFT_STATUS.DETAILS_HASH, 'deleted' ENUM value
 * 	10-10-22 add ENSH_ENFT_STATUS.NARRATIVE
 * 	09-26-22 add ENSH_ENFT_STATUS.CHAIN_ID
 * 	09-22-22 new
 *
 * purpose---
 * 	schema for Enshroud Auditor's internal database
 */

use enshroud;

drop table if exists ENSH_ENFT_KEYS;

/* table for records representing AES-256 keys for eNFTs */
create table ENSH_ENFT_KEYS (
	/* index hash value (chain+ID+owner) */
	HASH			varchar(64) not null,

	/* key value, Base64-UTF encoded */
	AES_KEY			varchar(64) not null,

	/* index */
	unique index (HASH)
	)
\g

drop table if exists ENSH_RECEIPT_KEYS;


/* table for records representing AES-256 keys for receipts */
create table ENSH_RECEIPT_KEYS (
	/* index hash value (chain+ID+owner) */
	HASH			varchar(64) not null,

	/* key value, Base64-UTF encoded */
	AES_KEY			varchar(64) not null,

	/* index */
	unique index (HASH)
	)
\g


drop table if exists ENSH_ENFT_STATUS;

/* table for records representing last status of a given eNFT ID */
create table ENSH_ENFT_STATUS (
	/* the ID of the eNFT */
	ENFT_ID			varchar(64) not null,

	/* the ID of the chain (per standard) on which the eNFT was issued */
	CHAIN_ID		bigint not null,

	/* the details hash, keccak256("[{address},{id},{asset},{amount}]") */
	DETAILS_HASH	varchar(64) not null,

	/* the current status, one of:
	 * valid = added to table by Auditor with good status
	 * suspect = needs to be greylisted on blockchain
	 * blocked = has been greylisted on blockchain
	 * deleted = has been burned, so status is no longer relevant
	 */
	STATUS			ENUM('valid','suspect','blocked','deleted')
						not null default 'valid',

	/* the original insert timestamp */
	INSERT_DATE		datetime not null,

	/* the ID of the Auditor who first submitted this record */
	SUBMITTER		varchar(16) not null,

	/* if the STATUS is suspect or blocked, the Auditor's error log extracts
	 * which justify the designation
	 */
	NARRATIVE		text,

	/* the timestamp of latest modification */
	LMOD_DATE		datetime,

	/* the ID of the Auditor who made the last update */
	UPDATER			varchar(16),

	/* index */
	unique index (ENFT_ID, CHAIN_ID),
	index (INSERT_DATE)
	)
\g
