#/bin/bash
#
# purpose---
#       purge database snapshot backups for local databases older than 2 weeks
#

BACKUPLOC=/var/backups/mysql
CONF=$BACKUPLOC/backup.conf

if [[ ! -f $CONF ]]
then
        echo "$0: $CONF missing, cannot run"
        exit 1
fi

# compute current date as seconds since epoch
cd $BACKUPLOC
curTime=$(date +%s)
# compute 2 weeks ago
twoWeeks=$(expr $curTime - 1209600)
twoWeeksAgo=$(date --date="@$twoWeeks" +"%Y%m%d%H%M")
touch -t $twoWeeksAgo $BACKUPLOC/reference

# go into each database directory being backed up
for database in $(cat $CONF)
do
	cd $BACKUPLOC/$database
	# examine each filename
	for backup in *.gz
	do
		# check date vs 2 week old reference
		if [[ $backup -ot $BACKUPLOC/reference ]]
		then
			/bin/shred -u $backup
		fi
	done
done
rm $BACKUPLOC/reference
exit 0
