#/bin/bash
#
# purpose---
#       perform database snapshot backups for local databases
#

BACKUPLOC=/var/backups/mysql
CONF=$BACKUPLOC/backup.conf

if [[ ! -f $CONF ]]
then
        echo "$0: $CONF missing, cannot run"
        exit 1
fi

# back up local databases on the list
for database in $(cat $CONF)
do
        if [[ ! -d $BACKUPLOC/$database ]]
        then
                mkdir $BACKUPLOC/$database
        fi
        cd $BACKUPLOC/$database
        # check date for backup file names
        bName=$(date +%Y-%m-%d-%H:%M)
        /usr/bin/mariadb-dump --max_allowed_packet=80M --opt -E $database > $bName.sql 2>/dev/null
        gzip $bName.sql
        chmod 400 $bName.sql.gz
done

exit 0
