/*
 * last modified---
 * 	07-16-25 add MVO_VPN_OFFSET and AUD_VPN_OFFSET
 * 	01-22-24 remove unused m_AuditorURI
 * 	09-07-22 new
 *
 * purpose---
 * 	serve as generic baseclass for MVO and AUD versions of MVOConfig
 */

package cc.enshroud.jetty;

import cc.enshroud.jetty.log.Log;

import java.net.URI;
import java.security.PublicKey;


/**
 * This class serves as a base for MVO configs, as interpreted differently by
 * mvo.MVOConfig and aud.MVOConfig.  This generic type serves as the value type
 * for the Hashtable in {@link SmartContractConfig}.
 */
public class MVOGenConfig {
	// constants
	/**
	 * offset at which AUD node IPs begin on VPNs, after router (.1)
	 * (eg numbering begins at .2)
	 */
	public static int				AUD_VPN_OFFSET = 1;

	/**
	 * offset at which MVO node IPs begin on VPNs, after router (.1)
	 * (eg numbering begins at .20)
	 */
	public static int				MVO_VPN_OFFSET = 20;

	// BEGIN data members
	/**
	 * ID of the MVO, used as an index and as address owner
	 */
	private String					m_MVOId;

	/**
	 * endpoint where this MVO listens for peer MVO requests (ws:)
	 */
	private URI						m_MVOURI;

	/**
	 * public key used for Layer2 communications with other MVOs and Auditors
	 */
	private PublicKey				m_CommPubKey;

	/**
	 * current status (up | down)
	 */
	private boolean					m_Status;

	/**
	 * logging object
	 */
	public Log						m_Log;

	// END data members

    // BEGIN methods
    /**
     * constructor
     * @param mvoId Id of server
     * @param log logging object
     */
    public MVOGenConfig(String mvoId, Log log) {
        m_MVOId = new String(mvoId);
        m_Log = log;
	}

	// GET methods
	/**
	 * obtain MVO Id
	 * @return the Id for the server
	 */
	public String getId() { return m_MVOId; }

	/**
	 * obtain MVO request URI
	 * @return the endpoint where this MVO listens for peer MVO requests
	 */
	public URI getMVOURI() { return m_MVOURI; }

	/**
	 * obtain the last reported status of the MVO
	 * @return up|down status
	 */
	public boolean getStatus() { return m_Status; }

	/**
	 * obtain the pubkey used to encrypt messages sent to this MVO
	 * @return the key used for securing messages sent to this MVO
	 */
	public PublicKey getCommPubKey() { return m_CommPubKey; }


	// SET methods
	/**
	 * configure the peer MVO request endpoint
	 * @param uri the relevant network endpoint serving requests
	 */
	public void setMVOURI(URI uri) {
		if (uri != null) {
			m_MVOURI = uri;
		}
		else {
			m_Log.error("MVOGenConfig.setMVOURI: missing URI");
		}
	}

	/**
	 * update status of MVO
	 * @param stat up (true) or down (false)
	 */
	public void setStatus(boolean stat) { m_Status = stat; }

	/**
	 * configure the public key used to secure messages sent to this MVO
	 * @param pubkey the appropriate public key
	 */
	public void configCommPubkey(PublicKey pubkey) {
		if (pubkey != null) {
			m_CommPubKey = pubkey;
		}
		else {
			m_Log.error("MVOGenConfig.configCommPubkey: missing key");
		}
	}

	// END methods
}
