/*
 * last modified---
 * 	03-12-24 add setupMVOStakingListener()
 * 	07-07-23 new
 *
 * purpose---
 * 	define an interface for performing tasks upon connecting to a JSON-RPC node
 */

package cc.enshroud.jetty;


/**
 * This interface abstracts tasks which must be performed each time a connect
 * is established to a blockchain's JSON-RPC ABI system.  Generally these are
 * initialization tasks, which should be performed on connect and repeated on
 * every reconnect in case the data on-chain has altered.  The L2 node main
 * classes (MVO and AUD) implement this interface.
 */
public interface BlockchainConnectListener {
	/**
	 * perform tasks required to obtain the node's own on-chain config
	 * @param scc the SC config which just became connected
	 * @return true on success
	 */
	public boolean getOwnNodeConfig(SmartContractConfig scc);

	/**
	 * perform tasks required to obtain other nodes' on-chain configs
	 * @param scc the SC config which just became connected
	 * @return true on success
	 */
	public boolean getOtherNodeConfigs(SmartContractConfig scc);

	/**
	 * create the listener which subscribes to MVOStatusChanged and
	 * MVOStakeUpdated events (AUD version simply returns)
	 * @param scc the SC config which just became connected
	 * @return true on success
	 */
	public boolean setupMVOStakingListener(SmartContractConfig scc);

	/**
	 * obtain the node Id of the owner
	 * @return the ID (MVOId or AUDId)
	 */
	public String getSelfId();
}
