/*
 * last modified---
 * 	09-28-22 new
 *
 * purpose---
 * 	provide an extension override which can map Apache commons logging to
 * 	our Log class
 */

package cc.enshroud.jetty.log;

import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;


/**
 * A LogFactory implementation to override the default commons-logging behavior.
 * All log statements are written to the Enshroud logs.  Info level logging
 * is sent to debug.  Info and debug logging with exceptions is sent to error.
 * Fatal is sent to error.  This style of logging is used by Proxool.
 */
public final class CommonsLogFactory extends LogFactory {
	/**
	 * the actual logging object we use
	 */
	private static Log						m_Log;

	/**
	 * the Apache commons logging object for which we supply overrides
	 */
	private org.apache.commons.logging.Log	m_ApacheLog;

	/**
	 * nullary constructor (System.PEER_ID must be set before calling)
	 */
	public CommonsLogFactory() {
		String peerId = System.getProperty("PEER_ID");
		m_Log = new Log("/var/log/enshroud/" + peerId + "-DB.log");
		m_Log.Init();
		m_ApacheLog = new org.apache.commons.logging.Log() {
			public boolean isDebugEnabled() { return true; }

			public boolean isErrorEnabled() { return true; }

			public boolean isFatalEnabled() { return true; }

			public boolean isInfoEnabled() { return true; }

			public boolean isTraceEnabled() { return false; }

			public boolean isWarnEnabled() { return true; }

			public void trace(Object obj) {
				// ignore
			}

			public void trace(Object obj, Throwable throwable) {
				// ignore
			}

			public void debug(Object obj) {
				m_Log.debug(obj.toString());
			}

			public void debug(Object obj, Throwable throwable) {
				m_Log.error(obj.toString(), throwable);
			}

			public void info(Object obj) {
				m_Log.debug(obj.toString());
			}

			public void info(Object obj, Throwable throwable) {
				m_Log.error(obj.toString(), throwable);
			}

			public void warn(Object obj) {
				m_Log.warning(obj.toString());
			}

			public void warn(Object obj, Throwable throwable) {
				m_Log.error(obj.toString(), throwable);
			}

			public void error(Object obj) {
				m_Log.error(obj.toString());
			}

			public void error(Object obj, Throwable throwable) {
				m_Log.error(obj.toString(), throwable);
			}

			public void fatal(Object obj) {
				m_Log.error(obj.toString());
			}

			public void fatal(Object obj, Throwable throwable) {
				m_Log.error(obj.toString(), throwable);
			}
		};
	}

	// override some other methods
	@Override
	public Object getAttribute(String string) { return null; }

	@Override
	public String[] getAttributeNames() { return new String[0]; }

	@Override
	public org.apache.commons.logging.Log getInstance(Class aClass)
		throws LogConfigurationException
	{
		return m_ApacheLog;
	}

	@Override
	public org.apache.commons.logging.Log getInstance(String string)
		throws LogConfigurationException
	{
		return m_ApacheLog;
	}

	@Override
	public void release() {
		m_Log.deInit();
	}

	@Override
	public void removeAttribute(String string) {
	}

	@Override
	public void setAttribute(String string, Object object) {
	}
}
