#!/bin/bash
#
# last modified---
#	07-11-24 new
#
# purpose---
#	ensure that the local AUD is running (to be run from root crontab)
#
# method---
#	search for the process, start if not found

# look for startup script, which persists in process table until the JVM exits
pslist=$(ps --no-headers -C "startAUD.sh")
if [[ -z $pslist ]]
then
	# this output will be discarded unless there's a MTA installed
	echo "restarting missing AUD at $(date)"
	# We utilize restart instead of start because it does a stop first.
	# Although the AUD isn't running, status is still 'active (exited)', so
	# a start will do nothing, since the app looks active.  Doing the stop
	# first resets the status, allowing start to work.
	/usr/sbin/service enshroud-aud restart
fi
exit 0
