/*
 * last modified---
 * 	12-20-23 add recordUnGreylist()
 * 	12-18-23 add recordBlock()
 * 	11-28-23 new
 *
 * purpose---
 * 	define an interface for listening for mint and burn events for eNFTs
 */

package cc.enshroud.jetty;

import java.math.BigInteger;


/**
 * This interface provides methods by which eNFT mint/burn events can be
 * subscribed.  A source listening to events on the blockchain can call
 * such a listener if it has one available.  See {@link EnftCache} and
 * {@link ReceiptQueue}.
 */
public interface EnftListener {
	/**
	 * record a eNFT mint event
	 * @param chainId the chain on which the mint occurred
	 * @param enftId the ID of the eNFT minted
	 * @param addr the wallet address to which the eNFT was minted
	 * @param block the block number in which the mint occurred
	 */
	public void recordEnftMint(long chainId,
							   BigInteger enftId,
							   String addr,
							   BigInteger block);

	/**
	 * record a eNFT burn event
	 * @param chainId the chain on which the burn occurred
	 * @param enftId the ID of the eNFT burned
	 * @param addr the wallet address from which the eNFT was burned
	 * @param block the block number in which the burn occurred
	 */
	public void recordEnftBurn(long chainId,
							   BigInteger enftId,
							   String addr,
							   BigInteger block);

	/**
	 * record a new block event
	 * @param chainId the chain on which the block was mined
	 * @param block the new block number
	 */
	public void recordBlock(long chainId, BigInteger block);

	/**
	 * record the fact that an eNFT ID was un-greylisted by 3 admins
	 * @param chainId the chain on which the ungreylist action occurred
	 * @param enftId the ID of the eNFT restored to valid status
	 */
	public void recordUnGreylist(long chainId, BigInteger enftId);
}
