/*
 * last modified---
 * 	10-30-24 new
 *
 * purpose---
 * 	define an interface for completely reinitializing Web3j, EnftCache objects
 */

package cc.enshroud.jetty;


/**
 * This interface provides a method by which an EnftCache can request its own
 * complete reinitialization, including rebuilding the ABI session (Web3j
 * interface object).  This is called whenever the cache gets into a situation
 * where its OkHttpClient or WebSocketService is malfunctioning and cannot be
 * recovered, short of starting afresh.  This class must be implemented by at
 * least one class in MVO and AUD nodes.  For usage see those classes plus
 * {@link EnftCache} and {@link SmartContractConfig}.
 */
public interface EnftCacheResetter {
	/**
	 * request a eNFT cache reset
	 * @param chainId the chain for which the connection and cache has failed
	 * @return true, unless the WSS service connection attempt failed
	 */
	public boolean requestEnftCacheRestart(long chainId, String reason);
}
